# Protein Domain Overlap

Proteins contain different *domains* (structural or functional units
responsible for a particular function).

We need a program that, given a list of domains in a protein, and their
positions in it, determines domain overlapping regions in the sequence.

## Input

The input is a list of protein domains found in a DNA sequence. For each
domain, the id of the protein, the name of the domain, and its position
span in the protein are given.

The input consists of an integer N (the number of protein domain
records), followed by N lines, each consisting of two strings, and two
integers:

`     protein_id domain_name start_position end_position`

where:\

- protein_id (string): The protein's identifier.

- domain_name (string): The name of the domain.

- start_position, end_position (integers): The span of the domain within
  the protein sequence.

## Output

List proteins in alphabetical order. For each protein, list its domains
in order of starting position. If any domain overlaps with the previous
one, mark it with \"OVERLAP\".

Print a summary list of the overlapping domains at the end of each
protein. If no overlaps exist, print \"No overlaps\".

Follow the format of the examples.

## Problem information

Author: Lluís Padró

Generation: 2026-01-25T20:04:00.036Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
