# Anagrames

Fes un programa que llegeix una seqüència de paraules i escriu els grups
d'aquestes paraules que són **anagrames** unes de les altres. Dues
paraules són anagrames si tenen les mateixes lletres (i en les mateixes
quantitats) però en un ordre diferent, com ara \"boca\" i \"obac\".

Per ajudar a resoldre el problema és útil tenir la funció `sort_chars`:

    #include <algorithm> // per std::sort
    using namespace std;

    /**
     * @brief Retorna un nou string amb les lletres de 
     *        `s` ordenades
     * 
     * @param  s  un `string`
     * @returns   Un nou string amb les lletres de `s` ordenades
     */
    string sort_chars(string s) {
        string sorted = s;
        sort(sorted.begin(), sorted.end());
        return sorted;
    }

(El programa principal proporcionat ja la conté.)

## Entrada

L'entrada és una seqüència de paraules, sense sentinella.

## Sortida

La sortida són els grups d'anagrames, un per línia, i a on cada grup
d'anagrames està ordenat per ordre lexicogràfic i amb un espai entre
cada parell de paraules. Si un grup d'anagrames té només un element (no
és un \"grup\" pròpiament), no s'ha de mostrar a la sortida. L'ordre de
les línies *no és important*, el Jutge només mira que cada grup
d'anagrames estigui present, no en quina posició.

## Observació

Els fitxers públics (icona del gatet) contenen:

  ------------ ------------------------------------------------
  `main.cc`    el programa principal i la funció `sort_chars`
  `Makefile`   per compilar amb `make` còmodament
  `.vscode`    carpeta per compilar i debuggar amb VSCode
  ------------ ------------------------------------------------

Cal enviar el fitxer `main.cc` (no cal fer un `.tar`).

## Informació del problema

Autoria: Pau Fernández

Generació: 2026-01-25T20:01:51.728Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
