# Canviar un element de lloc

Volem afegir el mètode **`canvia_lloc(i,j)`** a la classe `Llista`.

Aquest mètode mou l'element de la posició $i$ de la llista (el primer
element és a la posició $0$) i l'insereix *al davant* de l'element a la
posició $j$, tot eliminant-lo d'on estava (les posicions es refereixen
al lloc que ocupen els elements abans de fer cap operació sobre la
llista).

Per exemple, si la nostra llista $l$ és
$2\ 90\ 3\ 8\ 7\ 5\ 4\ 2\ 87\ 67$,

- $l$.`canvia_lloc(0,9)` deixa la llista $l$ així:
  $90\ 3\ 8\ 7\ 5\ 4\ 2\ 87\ 2\ 67$

- si després fem $l$.`canvia_lloc(4,7)` deixa la llista $l$ així:
  $90\ 3\ 8\ 7\ 4\ 2\ 5\ 87\ 2\ 67$

- si després fem $l$.`canvia_lloc(8,2)` deixa la llista $l$ així:
  $90\ 3\ 2\ 8\ 7\ 4\ 2\ 5\ 87\ 67$

- si després fem $l$.`canvia_lloc(3,3)` deixa la llista $l$ així:
  $90\ 3\ 2\ 8\ 7\ 4\ 2\ 5\ 87\ 67$

- si després fem $l$.`canvia_lloc(9,5)` deixa la llista $l$ així:
  $90\ 3\ 2\ 8\ 7\ 67\ 4\ 2\ 5\ 87$

- si després fem $l$.`canvia_lloc(7,8)` deixa la llista $l$ així:
  $90\ 3\ 2\ 8\ 7\ 67\ 4\ 2\ 5\ 87$

## Precondició

Suposarem que la llista no és buida, i que $0 \leq i,j < N$ on $N$ és la
mida de la llista

## Entrada

Primer hi ha un natural $n$, que ens indica el nombre d'elements de la
llista. Després apareixen $n$ nombres enters, que formen la llista
inicial. Després trobem una seqüència de parells de naturals $i$, $j$,
arguments per a que `canvia_lloc(i,j)` modifiqui la llista.

Vegeu els exemples que formen el joc de proves públic.

## Observacions

Dins el codi del mètode demanat **NO** podeu fer servir cap mètode de la
classe `Llista`. Heu de manipular exclusivament les instàncies de
`_Node` que formen la implementació de la llista.

Heu de baixar-vos el fitxer **`code.py`** (icona de la serp). Aquest
fitxer és un programa amb **tot** el que cal per executar els jocs de
prova públics. Només falta, clar, el mètode que us demana l'enunciat.
Aquest fitxer l'heu de completar amb el codi que falta, i això, **tot**,
és el que heu d'enviar al Jutge com a solució.

La representació textual de la llista $lst$ l'obtenim fent
`print(`$lst$`)`. Aquesta és la sortida del nostre programa: La llista
després de totes les transformacions indicades per l'entrada.

L'eficiència i la qualitat de la solució es tindran en compte a la
correcció manual.

## Informació del problema

Autoria: Jordi Delgado

Generació: 2026-01-25T20:01:19.425Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
