from pytokr import item, items

#------------------------------------------------------------------

class Llista:  # Hem eliminat alguns mètodes que no serveixen en aquest problema

    # ----------------------------------------------------
    # Classe interna per definir els elements de la llista:
    # Cada element de la llista serà una instància de _Node
    class _Node:
        __slots__ = '_element','_next','_prev' # opcional, per eficiència
        
        def __init__(self, prev, next, element=None): 
            self._element = element            # ref. a l'element emmagatzemat
            self._next = next                  # referència al proper node
            self._prev = prev                  # referència al node anterior 
    # ----------------------------------------------------
            
    def __init__(self):
        self._sentinella = self._Node(None,None)   # _Node sentinella
        self._sentinella._next = self._sentinella
        self._sentinella._prev = self._sentinella
        self._cursor   = self._sentinella
        self._n        = 0                    # nombre d'elements (sense sentinella!)

    def mida(self):                         
        return self._n

    def buida(self):
        return self._n == 0

    # Comprova si el cursor és al principi
    # de la llista 
    def principi(self):
        return self._cursor == self._sentinella._next
  
    # Comprova si el cursor és al final
    # de la llista    
    def final(self):
        return self._cursor == self._sentinella

    # Mou el cursor una posició enrere
    def enrere(self):
        # Pre: el cursor NO està al començament
        assert not self.principi() 
        self._cursor = self._cursor._prev

    # Mou el cursor una posició endavant   
    def endavant(self):
        # Pre: el cursor NO està al final
        assert not self.final()
        self._cursor = self._cursor._next

    # Mou el cursor al principi de la llista
    def anar_al_principi(self):
        self._cursor = self._sentinella._next

    # Mou el cursor al final de la llista 
    def anar_al_final(self):
        self._cursor = self._sentinella # !!!

    # Retorna l'element referenciat pel cursor
    def element(self):
        # Pre: el cursor NO està al final
        assert not self.final()
        return self._cursor._element

    # Insereix l'element x abans del cursor
    def inserir(self, x):
        p = self._Node(self._cursor._prev, self._cursor, x)
        self._cursor._prev._next = p
        self._cursor._prev = p
        self._n += 1
        return self

    # Elimina l'element ref. pel cursor
    # i avança el cursor una posició
    def eliminar(self):
        # Pre: el cursor NO està al final
        assert not self.final()
        p = self._cursor
        p._next._prev = p._prev
        p._prev._next = p._next
        self._cursor = p._next
        self._n -= 1

    def __str__(self):
        if not self.buida():
            p = self._sentinella._next
            s = str(p._element)
            p = p._next
            while p != self._sentinella:
                s += ' -- ' + str(p._element)
                p = p._next
            return s
        return ''

    def __iter__(self):
        self.anar_al_principi()
        return self

    def __next__(self):
        if self.final():
            raise StopIteration
        else:
            resultat = self.element()
            self.endavant()
            return resultat

    def canvia_lloc(self,i,j):
        # PRE: 0 <= i,j < N, on N és la mida de self
        #      self NO és buida
        # L'element que es troba a la posició i de self el
        # posem al davant del de la posició j de self, tot
        # eliminant-lo d'on estava.
        # Aquesta operació és destructiva: Modifica self.
        # El primer element és a la posició 0. No es modifica el cursor.
        # NO PODEU FER SERVIR CAP MÈTODE DE LA CLASSE LLISTA

        # Aquí cal que l'estudiant posi el seu codi <==================
        pass

#------------------------------------------------------------------

# Llegeixo la mida de la llista d'entrada

n = int(item())

lst = Llista()
for _ in range(n):
    lst.inserir(int(item()))

# Ara llegeixo parelles i,j per canviar els elements de lloc:

for i in items():
    i = int(i)
    j = int(item())
    lst.canvia_lloc(i,j)

# Escric la llista

print(lst)

