# Arbre general. Compta els elements de cada nivell

Donada la classe $Arbre$ que permet gestionar arbres generals usant
memòria dinàmica i un tipus $T$, cal implementar el mètode

      vector<T> compta_elements_nivells() const;

que retorna un vector amb el nombre d'elements de cada nivell de
l'arbre.

Cal enviar a jutge.org la següent especificació de la classe $Arbre$ i
la implementació del mètode dins del mateix fitxer. Indica dins d'un
comentari a la capçalera del mètode el seu cost en funció del nombre
d'elements $n$ de l'arbre.

    #include <cstdlib>
    #include <vector>
    using namespace std;
    typedef unsigned int nat;

    template <typename T>
    class Arbre {

    public:
      // Construeix un Arbre format per un únic node que conté a x.
      Arbre(const T &x);

      // Tres grans.
      Arbre(const Arbre<T> &a);
      Arbre& operator=(const Arbre<T> &a);
      ~Arbre() throw();

      // Col·loca l'Arbre donat com a darrer fill de l'arrel de l'arbre sobre el que s'aplica el mètode i l'arbre a queda invalidat; després de fer b.afegir\_fill(a), a no és un arbre vàlid.
      void afegir_darrer_fill(Arbre<T> &a);

      static const int ArbreInvalid = 400;

      vector<T> compta_elements_nivells() const;
      // PRE:  Cert
      // POST: Retorna un vector amb el nombre d'elements de cada nivell de l'arbre.

    private:
      Arbre(): _arrel(nullptr) {};
      struct node {
        T info;
        node* primf;
        node* seggerm;
      };
      node* _arrel;
      static node* copia_arbre(node* p);
      static void destrueix_arbre(node* p) throw();

      // Aquí va l'especificació dels mètodes privats addicionals

    };

    // Aquí va la implementació del mètode compta\_elements\_nivells i privats addicionals

Per testejar la solució, jutge.org ja té implementats la resta de
mètodes de la classe $Arbre$ i un programa principal que llegeix un
arbre general d'enters i desprès crida el mètode
$compta\_elements\_nivells$.

## Entrada

L'entrada consisteix en la descripció d'un arbre general d'enters (el
seu recorregut en preordre, en el qual al valor de cada node li segueix
el seu nombre de fills).

## Sortida

Una línia per cada nivell de l'arbre d'entrada, amb el nombre d'elements
del nivell en qüestió.

## Observació

Només cal enviar la classe requerida i la implementació del mètode
$compta\_elements\_nivells$ amb el seu cost en funció del nombre
d'elements $n$ de l'arbre. Pots ampliar la classe amb mètodes privats.
Segueix estrictament la definició de la classe de l'enunciat.

## Informació del problema

Autoria: Jordi Esteve

Generació: 2026-01-25T19:59:47.530Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
