# Vector U

Un **vector U** es un vector de enteros que tiene tres partes: una
bajada, un valle y una subida. La bajada $b_1 \dots b_k$ es un subvector
tal que todos los elementos están en orden *estrictamente decreciente*.
El valle $v_1 \dots v_m$ es un subvector en el que todos los elementos
son *iguales*. La subida $p_1 \dots p_n$ es un subvector tal que todos
sus valores están en orden *estrictamente creciente*.

Además, se cumplen estas dos condiciones:

1.  $k \geq 1$, $m \geq 3$ y $n \geq 1$. Dicho de otro modo: tanto la
    bajada como la subida tienen al menos un elemento, mientras que el
    valle tiene, al menos, tres.

2.  $b_k > v_1$ y $v_m < p_1$.

Por ejemplo, el vector `V = [5 4 3 2 1 1 1 6 7 8 9 10]` es un **vector
U**:

::: center
  ------------------------------- ----------------------------- ----------------------------------
   $\underbrace{\verb|5 4 3 2|}$   $\underbrace{\verb|1 1 1|}$   $\underbrace{\verb|6 7 8 9 10|}$
              bajada                          valle                           subida
  ------------------------------- ----------------------------- ----------------------------------
:::

El **codo U** es la posición de un vector U donde se encuentra $v_m$, es
decir, el último elemento del valle. Por ejemplo, para el vector
`V = [5 4 3 2 1 1 1 6 7 8 9 10]` la posición del codo U es 6, ya que es
la posición donde se encuentra el último elemento del valle.

Debes hacer la **función** `colzeU`, que devuelve la posición del codo U
de un vector U.

    /* PRE:  v es un vector U.
       POST: devuelve la posición del codo U de v.
    */

    int colzeU(const vector<int>& v);

## Observación

Solo debes enviar un fichero que contenga la función requerida, con los
`include` necesarios y las funciones auxiliares que hayas declarado (si
las hay), y **nada más**.

Propón una solución utilizando búsqueda dicotómica para este ejercicio.
Cualquier otro tipo de solución implica la anulación **total** de todo
el ejercicio, independientemente del veredicto del juez.

## Entrada

Un vector U de enteros.

## Salida

La posición del codo U.

## Información del problema

Autoría: PRO1

Generación: 2026-01-25T19:58:52.453Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
