# Mitjana de les subllistes de mida k

Implementa una acció **ITERATIVA** que, donada una llista d'enters $l$ i
un natural $k$, torni una altra llista amb les mitjanes de cada
subllista de mida $k$ començant pel principi de la llista.

La capçalera de l'acció és la següent:

    // \textbf{Pre}: k $>$ 0
    // \textbf{Post}: omple la llista \emph{mitjs} amb les mitjanes de les subllistes de
    //   mida \emph{k} de la llista \emph{l} començant des de primer element de la llista.
    void mitjana_subllistes(const list<int> &l, unsigned int k, list<double> &mitjs)

Per exemple, si ens passen la llista `[33, 12, 18, 32, 6, 11, 2]` i k=3
les subllistes de mida 3 serien:

::: center
  ----- --------- --------- --------- --------- -------- -------- ------- ----- -------------
   $[$     33,       12,       18,       32,       6,      11,       2     $]$  
         $[$ 33,     12,     18 $]$                                                **21**
                   $[$ 12,     18,     32 $]$                                    **20.6667**
                             $[$ 18,     32,     6 $]$                           **18.6667**
                                       $[$ 32,     6,     11 $]$                 **16.3333**
                                                 $[$ 6,    11,     2 $]$         **6.33333**
  ----- --------- --------- --------- --------- -------- -------- ------- ----- -------------
:::

Per tant, la llista que conté la mitjana de cada subllista és:

`[21, 20.6667, 18.6667, 16.3333, 6.33333]`.

## Observació

Només cal enviar el procediment demanat; el programa principal serà
ignorat.

## Observació

Les subrutines que creïs han de treballar només amb llistes (la classe
`list` de la biblioteca STL). Has de trobar una solució **ITERATIVA** i
eficient del problema. En particular, no hi hauria d'haver cap crida
recursiva en cap de les subrutines que implementis. Si crees subrutines
auxiliars, afegeix-hi les corresponents **Pre** i **Post**. En els
bucles inclou l'**invariant del bucle** i la **funció de fita**.

## Informació del problema

Autoria: Bernardino Casas

Generació: 2026-01-25T19:58:45.509Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
