#include <iostream>
#include <string>
#include <list>
#include <sstream>

using namespace std;

void mitjana_subllistes(const list<int> &l, unsigned int k, list<double> &migs);

#ifndef IOLISTFUNCTIONS
#define IOLISTFUNCTIONS

template <typename T>
void readList(const string &line, list<T> &l) {
	istringstream mycin(line);
	T x;
	while (mycin >> x) {
		l.push_back(x);
	}
}

template <typename T>
void writeListRec(typename list<T>::const_iterator it, typename list<T>::const_iterator end) {
	if (it != end) {
    cout << ", " << *it;
    writeListRec<T>(++it, end);
  }
}

template <typename T>
void writeList(const list<T> &l) {
	if (l.empty()) {
		cout << "[]" << endl;
	}
	else {
		cout << '[' << *(l.begin());
		writeListRec<T>(++l.begin(), l.end());
		cout << ']' << endl;
	}
}

#endif

int main() {
	string lin;
	while (getline(cin, lin)) {
		int i1 = lin.find('[');
		int i2 = lin.find(']', i1+1);
		string s = lin.substr(i1+1, i2-i1-1);
		list<int> la;
		readList<int>(s, la);
		
		string s2 = lin.substr(i2+1, lin.size() - i2 -1);
		istringstream mycin(s2);
		unsigned int k;
		mycin >> k;
		// cin.ignore(); // Evita problemes amb el buffer d'entrada

		list<double> res;		
		mitjana_subllistes(la, k, res);
		writeList<double>(res);
	}	
	return 0;
}
