# Matriculaciones

Queremos simular las modificaciones de la matrícula de estudiantes a
asignaturas de la FIB. Al inicio se leerá la matrícula original de
estudiantes i después el programa ofrecerá un menú de opciones:

- \"`matricula`\" lee un nombre de estudiante y una asignatura, y
  consiste en asignar la asignatura leída al estudiante. Si el
  estudiante ya estaba matriculado a aquella asignatura no hay que hacer
  nada.

- \"`anular`\" lee un nombre de estudiante y una asignatura, y se
  elimina la asignatura del conjunto de asignaturas matriculadas por el
  estudiante. Si el estudiante no había matriculado la asignatura no se
  hace nada. Si el estudiante ha anulado todas las asignaturas que
  hubiera matriculado, éste/a saldrá del sistema. Si es por el contrario
  la asignatura la que se ha quedado con zero estudiantes, consideramos
  que la asignatura todavía existe en el sistema, aunque no tenga
  estudiantes matriculados.

- \"`matricula_asignatura`\" lee un nombre de asignatura, y escribe el
  número de estudiantes matriculados en ella.

- \"`matricula_estudiante`\" lee un nombre de estudiante, y escribe la
  relación de asignaturas matriculadas por éste en orden alfabético.

- \"`fin`\", que indica la finalización del programa.

Después de ejecutar la opción \"`fin`\" y salir del menú, se escribe en
orden alfabético la relación de asignaturas que se han matriculado en
algún momento (aunque se hayan anulado sus matrículas), y el número de
estudiantes que las van a cursar. Además, también se escribirá por orden
alfabético la relación de estudiantes que tienen asignaturas
matriculadas (no aquellos que hayan anulado todas las asignaturas que
hubieran matriculado), seguido de las asignaturas que van a cursar.

## Entrada

Primero se lee el número de estudiantes matriculados (un entero), y
luego los correspondientes nombres de estudiantes seguidos de las
asignaturas matriculadas. Cada estudiante y sus asignaturas ocupan una
línea, y el estudiante es un solo string sin espacios, y las asignaturas
son también `string`s separados por espacios.

Las opciones de menú tienen un formato variable pero empiezan siempre
por la opción como un `string`, i en cada caso le siguen los datos
necesarios para ejecutar la opción, que son un nombre de estudiante o de
asignatura, o ambos. No hay que suponer que las opciones de menú estan
en líneas separadas, pueden estar todas seguidas.

## Salida

La salida consiste en una parte con la salida de cada una de las
opciones del menú indicadas a la entrada, cuyas opciones tienen la
salida siguiente:

- `matricula`: no produce salida.

- `anular`: no produce salida.

- `matricula_asignatura`: Se muestra una frase como "`asig` tiene `num`
  matriculados", donde `asig` es el nombre de la asignatura y `num` es
  el número de estudiantes matriculados.

- `matricula_estudiante`: Se muestra una frase como "`est` `a1` `a2`
  ...", donde `est` es el nombre del estudiante y `a1`, `a2`, ...son las
  asignaturas matriculadas por el estudiante. Si el estudiante no tiene
  asignaturas matriculadas, entonces hay que mostrar: "`est` no tiene
  asignaturas matriculadas".

Una vez detectada la opción "`fin`", el programa muestra un listado de
las asignaturas y el número de matriculados, ordenado por nombre de
asignatura, con una asignatura por línea, y con una línea vacía al
final.

Después se muestra un listado de los estudiantes, ordenado por nombre de
estudiante, y las asignaturas que cursan, ordenadas por nombre de
asignatura, y con una línea vacía al final.

## Observación

**Nota**: es conveniente que uses la clase `stringstream` y la acción
`getline` para poder leer secuencias sin centinela delimitadas por el
salto de línea. Recuerda que al leer un entero, hay que leer un
`getline` extra para consumir el salto de línea.

## Información del problema

Autoría: PRO2

Generación: 2026-01-25T21:39:24.879Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
