# Matriculacions

Volem simular les modificacions de la matrícula d'estudiants a
assignatures de la FIB. Al començament es llegirà la matrícula original
d'estudiants i després el programa oferirà un menú d'opcions:

- \"`matricula`\" llegeix un nom d'estudiant i una assignatura, i
  consisteix a assignar l'assignatura llegida a l'estudiant. Si
  l'estudiant ja estava matriculat a aquella assignatura, no caldrà fer
  res.

- \"`anular`\" llegeix un nom d'estudiant i una assignatura, i s'elimina
  l'assignatura del conjunt d'assignatures matriculades per l'estudiant.
  Si l'estudiant no havia matriculat l'assignatura no es fa res. Si
  l'estudiant ha anul·lat totes les assignatures que hagués matriculat,
  aquest/a sortirà del sistema. Si per contra és l'assignatura la que
  s'ha quedat amb zero estudiants, considerem que l'assignatura encara
  existeix en el sistema, tot i que no tingui estudiants matriculats.

- \"`matricula_assignatura`\" llegeix un nom d'assignatura, i escriu el
  nombre d'estudiants matriculats en ella.

- \"`matricula_estudiant`\" llegeix un nom d'estudiant, i escriu la
  relació d'assignatures matriculades per aquest en ordre alfabètic.

- \"`fi`\", que indica la finalització del programa.

Després d'executar l'opció \"`fi`\" i sortir del menú, s'escriu en ordre
alfabètic la relació d'assignatures que s'han matriculat en algun moment
(tot i que s'hagin anul·lat les seves matrícules), i el nombre
d'estudiants que les cursaran. A més, també s'escriurà per ordre
alfabètic la relació d'estudiants que tenen assignatures matriculades
(no aquells que hagin anul·lat totes les assignatures que haguessin
matriculat), seguit de les assignatures que cursaran.

## Entrada

Primer es llegeix el nombre d'estudiants matriculats (un enter), i
després els corresponents noms d'estudiants seguits de les assignatures
matriculades. Cada estudiant i les seves assignatures ocupen una línia,
i l'estudiant és un sol string sense espais, i les assignatures són
també `string`s separats per espais.

Les opcions de menú tenen un format variable però comencen sempre per
l'opció com un `string`, i en cada cas segueixen les dades necessàries
per executar l'opció, que són un nom d'estudiant o d'assignatura, o tots
dos. No cal suposar que les opcions de menú estan en línies separades,
poden estar totes seguides.

## Sortida

La sortida consisteix en una part amb la sortida de cadascuna de les
opcions del menú indicades a l'entrada, les opcions de les quals tenen
la sortida següent:

- `matricula`: no produeix sortida.

- `anular`: no produeix sortida.

- `matricula_assignatura`: Es mostra una frase com "`asig` té `num`
  matriculats", on `asig` és el nom de l'assignatura i `num` és el
  nombre d'estudiants matriculats.

- `matricula_estudiant`: Es mostra una frase com "`est` `a1` `a2` ...",
  on `est` és el nom de l'estudiant i `a1`, `a2`, ...són les
  assignatures matriculades per l'estudiant. Si l'estudiant no té
  assignatures matriculades, aleshores cal mostrar: "`est` no té
  assignatures matriculades".

Una vegada detectada l'opció "`fi`", el programa mostra un llistat de
les assignatures i el nombre de matriculats, ordenat per nom
d'assignatura, amb una assignatura per línia, i amb una línia buida al
final.

Després es mostra un llistat dels estudiants, ordenat per nom
d'estudiant, i les assignatures a les que estan matriculats, ordenades
per nom d'assignatura, i amb una línia buida al final.

## Observació

**Nota**: és convenient que facis servir la classe `stringstream` i
l'acció `getline` per poder llegir seqüències sense centinella
delimitades pel salt de línia. Recorda que en llegir un enter, cal
llegir un `getline` extra per consumir el salt de línia.

## Informació del problema

Autoria: PRO2

Generació: 2026-01-25T21:39:29.736Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
