# Ordena un Vector V

Un **vector V** es un vector que está compuesto de dos partes:

$$v = x_1 ~ x_2 ~ x_3 ~ x_4 \dots x_n ~ y_1 ~ y_2~ y_3 \dots y_m$$

tales que $x_1 \dots x_n$ está ordenado de forma escrita **decreciente**
y $y_1 \dots y_m$ está ordenado de forma escrita **creciente**. Además,
$x_n > y_1$. Por último tenemos que $n,m > 0$. Es decir, ninguna de las
dos partes está vacía.

Es necesario implementar la **función**

`void ordena(const vector<int>& v, int pos, vector<int>& r)`

con la siguiente especificación:

`PRE:` $v$ es un vector V como $\mid \! v \! \mid \geq 3$, $pos$ es la
posición en la que se encuentra $y_1$ en $v$ y
$\mid \! v \! \mid = \mid \! r \! \mid$.

`POST:` El vector $r$ contiene todos los elementos del vector $v$ y está
ordenado.

## Observación

Sólo tiene que enviar la función que le pedimos y las acciones y
funciones que vosotros mismos defina.

No se puede utilizar la operación `sort` de la biblioteca `stl`.

Pista: saber la posición en la que se encuentra $y_1$ le puede ayudar a
ordenar el vector en tiempo lineal.

**IMPORTANTE:** Sólo hay que enviar la función que se pide, y quizás
otras acciones y funciones necesarias. Hay que mantener, sin embargo,
las definiciones de tipos y los `#include`s.

## Entrada

Un número indeterminado de vectores V con el siguiente formato: un
entero que indica su tamaño, después el vector V, despues la posición en
la que se encuentra $y_1$ en $v$ y un vector $r$ del mismo tamaño que
$v$. Todo vector V tiene un tamaño mayor o igual a 3.

## Salida

El vector $r$ está ordenado y contiene todos los elementos de $v$.

## Información del problema

Autoría: PRO1

Generación: 2026-01-25T23:07:25.893Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
