# Liga de Fútbol

Después de muchos obstáculos, la Federación Catalana de Fútbol ha
exitoso a organizar la Liga Nacional Catalana de Fútbol y ha pedido a la
FIB que les ayude con la gestión de los datos de los resultados de la
temporada.

Concretamente, debe hacer un **programa** tal que dado un entero
$n \geq 2$ y $n$ nombres **diferentes** de equipos de fútbol catalanes y
después un número indeterminado de resultados en forma de cuádruples:

$$equipo_1 ~~ goles_1 ~~ equipo_2 ~~ goles_2$$

que representan el resultado de un partido, calcule la clasificación
final teniendo en cuenta que el orden viene dado por:

1.  El número de puntos (partido ganado: 3 puntos, partido empatado: 1
    punto).

2.  En caso de empate a puntos, va primero quien tiene mejor diferencia
    de goles (diferencia entre goles hechos y goles recibidos).

3.  En caso de empate en ambos casos anteriores, quien tiene el nombre
    de equipo **más pequeño** en orden lexicográfico.

Para hacer este programa **es necesario** utilizar esta estructura:

    struct Equip
    {
        string nom;
        int gols_favor;
        int gols_contra;
        int guanyats;
        int empatats;
    };

## Observación

El número $n \geq 2$ de equipos no debe ser necesariamente par. Del
mismo modo, los partidos que habrá no deben ser necesariamente todos los
posibles (es decir, todos contra todos en casa y fuera).

Aunque es irrelevante para su programa, un partido no podrá aparecer más
de una vez, ni siquiera con resultados distintos.

En un partido sólo aparecerán equipos que hayan aparecido en la lista
inicial de $n$ equipos.

No se puede utilizar la operación `suerte` de la biblioteca `stl`. Si
tiene que ordenar algún vector, debe programarlo usted. Y en su caso,
cualquier método de ordenación de los que ha estudiado es válido.

Fíjese en el segundo ejemplo: todos los equipos han ganado lo mismo
número de partidos y todos tienen la misma diferencia de goles. Los
equipos van ordenados en este caso en orden lexicográfico.

## Entrada

Un entero $n \geq 2$ y $n$ nombres de equipo de fútbol seguidos de un
número indeterminado de resultados en forma de cuádruples:

$$equipo_1 ~~ goles_1 ~~ equipo_2 ~~ goles_2$$

que representan el resultado de un partido.

## Salida

La clasificación final en el formato indicado en los ejemplos, y con los
criterios de ordenación mencionados en el enunciado.

## Información del problema

Autoría: PRO1

Generación: 2026-01-25T23:07:12.938Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
