# Suma recursiva de un vector

En este problema, habrá que implementar la suma de los elementos de un
vector de forma **recursiva**, es decir, sin usar ningún bucle (`for` o
`while`).

Implementa una función `suma_vector` con la siguiente declaración:

    #include <vector>
    using namespace std;

    /**
     * @brief Calcula la suma de los elementos de un vector a partir de la 
     *        casilla `c` hasta el final del vector, de forma recursiva.
     *
     * @param v El vector de enteros a sumar
     * @param c El índice a partir del cual se empieza a sumar
     *
     * @pre c >= 0
     *
     * @returns La suma de los elementos v[c] + v[c+1] + ... + v[n-1], donde
     *          n es el tamaño del vector. Si c >= n, devuelve 0.
     */
    int suma_vector(vector<int>& v, int c);

Por ejemplo, si tenemos un vector `v` con los elementos
`{3, 1, 4, 1, 5}` y llamamos `suma_vector(v, 0)`, el resultado será 14
(la suma de todos los elementos). Si llamamos `suma_vector(v, 2)`, el
resultado será 10 (la suma de `4 + 1 + 5`).

## Observación

El centro de interés de este problema es la *corrección*. Los casos de
prueba comprueban que la mayoría de casos posibles produzcan la salida
correcta.

**IMPORTANTE**: Al enviar este problema, hay que poner en el fichero
`.cc` solo la función `suma_vector` con los includes necesarios. Hay que
borrar (o comentar con `/*` y `*/`) la función `main` y `llegir_vector`
si habéis modificado el `main.cc` proporcionado.

## Entrada

*La entrada ya la hace el programa principal proporcionado*. Consiste en
varios casos. Cada caso empieza con un entero $n$ ($n \geq 0$) que
indica el tamaño del vector, seguido de $n$ enteros que son los
elementos del vector.

## Salida

*La salida también la produce el programa principal proporcionado*. Para
cada caso, se muestra la suma de los elementos del vector en una línea.

## Información del problema

Autoría: Unknown\
Traducción: Pau Fernández

Generación: 2026-02-03T07:44:32.837Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
