# Suma recursiva d'un vector

En aquest problema, caldrà implementar la suma dels elements d'un vector
de forma **recursiva**, és a dir, sense fer servir cap bucle (`for` o
`while`).

Implementa una funció `suma_vector` amb la declaració següent:

    #include <vector>
    using namespace std;

    /**
     * @brief Calcula la suma dels elements d'un vector a partir de la 
     *        casella `c` fins al final del vector, de forma recursiva.
     *
     * @param v El vector d'enters a sumar
     * @param c L'índex a partir del qual es comença a sumar
     *
     * @pre c >= 0
     *
     * @returns La suma dels elements v[c] + v[c+1] + ... + v[n-1], on
     *          n és la mida del vector. Si c >= n, retorna 0.
     */
    int suma_vector(vector<int>& v, int c);

Per exemple, si tenim un vector `v` amb els elements `{3, 1, 4, 1, 5}` i
cridem `suma_vector(v, 0)`, el resultat serà 14 (la suma de tots els
elements). Si cridem `suma_vector(v, 2)`, el resultat serà 10 (la suma
de `4 + 1 + 5`).

## Observació

El centre d'interès d'aquest problema és la *correctesa*. Els jocs de
prova comproven que la majoria de casos possibles produeixin la sortida
correcta.

**IMPORTANT**: Quan envieu aquest problema, cal posar en el fitxer `.cc`
només la funció `suma_vector` amb els includes necessaris. Cal esborrar
(o comentar amb `/*` i `*/`) la funció `main` i `llegir_vector` si heu
modificat el `main.cc` proporcionat.

## Entrada

*L'entrada ja la fa el programa principal proporcionat*. Consisteix en
un seguit de casos. Cada cas comença amb un enter $n$ ($n \geq 0$) que
indica la mida del vector, seguit de $n$ enters que són els elements del
vector.

## Sortida

*La sortida també la produeix el programa principal proporcionat*. Per a
cada cas, es mostra la suma dels elements del vector en una línia.

## Informació del problema

Autoria: Pau Fernández

Generació: 2026-02-03T07:44:28.301Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
