# Suma parcial dels elements d'una llista

Implementa un nou métode **iteratiu** de la classe List amb punters que,
donada una llista d'enters, substitueixi cada element per la suma dels
elements que té per endavant, fins al final de la llista.\
\
Per exemple: la llista\
3 7 9 -1 4 3 4\
\
quedarà\
26 19 10 11 7 4 0\
\
perquè\
\
davant del 3 hi ha els elements 7+9-1+4+3+4=26\
davant del 7 hi ha els elements 9-1+4+3+4=19\
davant del 9 hi ha els ements -1+4+3+4=10\
davant del -1 hi ha els elements 4+3+4=11\
davant del 4 hi ha els elements 3+4=7\
davant del 3 hi ha el 4\
i davant del 4 no hi ha cap element, per tant se substitueix per 0\

aquest mètode ha de trobar-se en el fitxer \"ReplaceSumList.cpp\" i ha
de tenir la següent capçalera

    /* Pre: cert. */
    /* Post: Substitueix cada element de la llista per la suma de tots 
    els elements que té al davant, fins al final de la llista */
    template<typename T>
    void List<T>::ReplaceSumList() {
    }

NOTES IMPORTANTS:

- L'algorisme ha de ser eficient, és a dir, que no realitzi càlculs
  innecessaris.

- Entre els fitxers que s'adjunten en aquest exercici trobaràs el fitxer
  List.h que conté la implementació de la classe List amb punters. No
  cal que modifiquis aquest fitxer.

- També trobaràs el fitxer program.cpp i el Makefile per a compilar i
  generar l'executable. El programa principal ja s'encarrega de llegir
  les dades de la llista i cridar al mètode indicat. **Només cal que
  implementis el mètode ReplaceSumList**.

- Es valorarà la correctesa i eficiència de la solució així com la
  correcta especificació de la precondició, la postcondició, la
  invariant del bucle i la funció fita.

- Per a pujar la solució has de crear el fitxer solution.tar així:\
  \
  tar cf solution.tar ReplaceSumList.cpp

## Entrada

Com a entrada hi haurà el número d'elements de la llista i els elements.

## Sortida

Com a sortida es mostrarà la llista amb els elements substituits.

## Informació del problema

Autoria: Alejandro Ríos

Generació: 2026-01-25T21:37:57.473Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
