
#include "List.h"

template <typename T> class Iterator
{
    friend class List<T>;

    private:
        List<T> *plist;
        typename List<T>::Node *pit;


    public:
        Iterator<T>()
        {
        }

        Iterator<T>(List<T> &list)
        {
            plist=&list;
            pit=list.first;
        }

        T& operator*()
        {
            return pit->value;
        }

        void operator++()
        {
            if (pit->next!=nullptr)
            {
                pit=pit->next;
            }
        }

        void operator--()
        {
            if (pit->prev!=nullptr)
            {
                pit=pit->prev;
            }
        }

        bool operator==(Iterator &it)
        {
            return pit==it.pit and plist=it.plist;
        }

        void insertItem(T value)
        {
            if (pit==nullptr or pit==plist->first)
            {
                plist->push_front(value);
            }
            else
            {
                typename List<T>::Node *newNode=new typename List<T>::Node();
                newNode->value=value;
                newNode->prev=pit->prev;
                newNode->next=pit;
                pit->prev->next=newNode;
                pit->prev=newNode;
                plist->_size++;
            }
        }

        void removeItem()
        {
            typename List<T>::Node *aux=pit;
            pit=aux->next;
            plist->removeNode(aux);
        }
};
