#include <iostream>
using namespace std;

template <typename T> class List
{
    public:
        class Node
        {
            public:
            T value;
            Node *next;
            Node *prev;
        };
       int _size;
       Node *first;
       Node *last;

    public:
        List()
        {
            first=nullptr;
            last=nullptr;
            _size=0;
        }

        List(List &l)
        {
            for (Node *pNode=l.first; pNode!=nullptr; pNode=pNode->next)
            {
                push_back(pNode->value);
            }
        }

        ~List()
        {
            removeItems();
        }

        List& operator=(const List &l)
        {
            if (this!=&l)
                removeItems();
            for (Node *pNode=l.first; pNode!=nullptr; pNode=pNode->next)
            {
                push_back(pNode->value);
            }
            return *this;
        }

        bool empty() const
        {
            return _size==0;
        }

        int size() const
        {
            return _size;
        }

        void push_back(const T &value)
        {
            Node *pNode=new Node();
            pNode->value=value;
            if (first==nullptr)
                first=pNode;
            else
            {
                last->next=pNode;
                pNode->prev=last;
            }

            last=pNode;
            _size++;
        }

        void push_front(const T &value)
        {
            Node *pNode=new Node();
            pNode->value=value;
            if (first==nullptr)
            {
                first=pNode;
                last=pNode;
            }
            else
            {
                pNode->next=first;
                first->prev=pNode;
                first=pNode;
            }
        }

        void pop_back()
        {
            removeNode(last);
        }

        void pop_front()
        {
            removeNode(first);
        }

        void removeNode(Node *pNode)
        {
            if (pNode!=nullptr)
            {
                if (pNode==first)
                    first=pNode->next;

                else
                {
                    if (pNode==last)
                    {
                        last=last->prev;
                        pNode->prev->next=nullptr;
                    }
                    else
                    {
                        if (pNode->prev!=nullptr)
                            pNode->prev->next=pNode->next;
                        if (pNode->next!=nullptr)
                            pNode->next->prev=pNode->prev;
                    }
                }

                delete pNode;

                _size--;
            }
        }
        void removeItems()
        {
            while (_size>0)
                removeNode(last);
        }

        friend istream& operator>>(istream& is, const List<T>& l)
        {
            for (Node *pNode=l.first;pNode!=nullptr;pNode=pNode->next)
            {
                is << pNode->value << " ";
            }
			return is;
        }

        friend ostream& operator<<(ostream& os, const List<T>& l)
        {
            for (Node *pNode=l.first;pNode!=nullptr;pNode=pNode->next)
                os << pNode->value << " ";
            return os;
        }
		
		void ReplaceSumList();
};