# Luz, Necesito más Luz!

El encargado de mantenimiento de la universidad enciende y apaga las
bombillas de los pasillos de la misma cuando es necesario. Cada bombilla
tiene su propio *switch* que cambia el estado de encendido de la
bombilla. Si ésta está apagada, y se presiona su switch, entonces se
enciende; volver a presionar el *switch* la apagará de nuevo.
Inicialmente cada bombilla está apagada.

El encargado sigue un comportamiento peculiar. Si hay $n$ bombillas en
un cierto pasillo, partiendo de una posición inicial, el camina a lo
largo del pasillo de ida y vuelta $n$ veces. En la i-esima caminata,
cuando va de ida por el pasillo, él presiona solo los *switches* cuya
posición es divisible por $i$. En nunca presiona ningún *switch* en el
viaje de regreso a la posición inicial. La i-ésima caminata se define
como el paso del encargado por el pasillo incluyendo tanto la idea hacia
el final del mismo (donde está la última bombilla) como el regreso a la
posición de inicio. Determina el estado final de la última bombilla,
¿estará encendida o apagada?

Por ejemplo, considere $n = 3$, entonces solo nos interesa la última
bombilla y su estado final. El encargado pasea 3 veces hasta alcanzarla.
Al inicio está apagada. En la vuelta $i=1$, como 3 es divisible por $1$
entonces se enciende. En la vuelta $i=2$, como 3 no es divisible por $1$
se mantiene encendida. En la vuelta $i=3$, como 3 es divisible por $3$
entonces se apaga. Siendo $i=3$ la última vuelta, entonces el estado
final de la bombilla es apagado.

## Entrada

La entrada será un entero indicando la $n$-ésima bombina en el pasillo,
el cual satisface $n \leq 2^{32} - 1$.

## Salida

Imprimir *ENCENDIDA* o *APAGADA* para indicar el estado final de la
última bombilla.

## Observación

- No olvide imprimir un salto de línea al final.

## Información del problema

Autoría: Nelson Rangel Valdez

Generación: 2026-01-25T23:04:03.746Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
