# Nombre de subexpressions amb avaluació igual al paràmetre

**INTRODUCCIÓ:**

En aquest exercici considerarem arbres que representen expressions sobre
els operadors `+,-,*`, i sobre operands naturals. Per exemple, l'arbre
`-(+(3,*(4,2)),5)` representa l'expressió `3+4*2-5`.

**EXERCICI:**

Implementeu una funció que, donat un arbre binari `t` d'strings que
representa una expressió correcta sobre naturals i operadors `+,-,*`, i
un paràmetre enter `x`, retorna quantes subexpressions de `t` s'avaluen
a `x`. Aquesta és la capcelera:

    // Pre:  t és un arbre no buit que representa una expressió correcta
    //       sobre els naturals i els operadors +,-,*.
    //       Les operacions no produeixen errors d'overflow.
    // Post: Retorna el nombre de subarbres de t que s'avaluen a x.
    int numberSubtreesEvaluateToParam(const BinaryTree<string> &t, int x);

Aquí tenim un exemple de paràmetres d'entrada de la funció i la
corresponent sortida:

    numberSubtreesEvaluateToParam(*(+(1,2),-(6,3)), 3) = 3

Fixeu-vos que l'enunciat d'aquest exercici ja ofereix uns fitxers que
haureu d'utilitzar per a compilar:
`Makefile, program.cpp, BinaryTree.hpp, numberSubtreesEvaluateToParam.hpp, utils.hpp, utils.cpp`.
Us falta crear el fitxer `numberSubtreesEvaluateToParam.cpp` amb els
corresponents `includes` i implementar-hi la funció anterior. Valdrà la
pena que utilitzeu algunes de les funcions oferides a `utils.hpp`. Quan
pugeu la vostra solució al jutge, només cal que pugeu un `tar` construït
així:

    tar cf solution.tar numberSubtreesEvaluateToParam.cpp

## Entrada

L'entrada té un nombre arbitrari de casos. Cada cas consisteix en una
primera línia amb un string describint un arbre binari d'strings, i una
segona línea amb un enter. Fixeu-vos en que el programa que us oferim ja
s'encarrega de llegir aquestes entrades. Només cal que implementeu la
funció abans esmentada.

## Sortida

Per a cada cas, la sortida conté el corresponent nombre de subarbres que
s'avaluen a l'enter donat. Fixeu-vos en que el programa que us oferim ja
s'encarrega d'escriure aquest nombre. Només cal que implementeu la
funció abans esmentada.

## Observació

La vostra funció i subfuncions que creeu han de treballar només amb
arbres. Heu de trobar una solució **RECURSIVA** del problema.
Possiblement necessitareu alguna funció auxiliar.

## Informació del problema

Autoria: PRO1

Generació: 2026-01-25T21:36:47.670Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
