# Descriure un camí en un arbre

En aquest exercici tenim arbres d'strings d'entrada que representen un
laberint de sales. Cada node és una sala que es representa amb el mot
`room`. Com a excepció, hi ha dues sales especials amb mots `start` i
`finish`, respectivament. Aquí en tenim un exemple:

                            room
                             |
                ------------- -------------
               |                           |
              room                        room
               |                           |
           ---- ----                   ---- ----
          |         |                 |         |
         room      room              room      room
          |                           |
      ---- ----                   ---- ----
     |         |                 |         |
    room     start              room      room
               |                 |
           ---- ----         ---- ----
          |         |       |         |
         room      room    room     finish

Haurem de modificar l'arbre d'entrada indicant-hi quin és el camí que
ens porta des del node `start` fins al node `finish`. Amb l'exemple
anterior, el resultat seria aquest:

                          right
                            |
               ------------- -------------
              |                           |
              up                         left
              |                           |
          ---- ----                   ---- ----
         |         |                 |         |
         up       room              left      room
         |                           |
     ---- ----                   ---- ----
    |         |                 |         |
    up      start             right      room
              |                 |
          ---- ----         ---- ----
         |         |       |         |
        room      room    room     finish

Mireu els exemples dels jocs de proves per tal de veure com representar
casos especials.

Per tal de simplificar la tasca, només caldrà que implementeu la següent
funció:

    // Pre:  Sigui T el valor inicial de t. T conté com a mínim dos nodes.
    //       Tots els nodes de T contenen l'string "room", excepte dos
    //       nodes en particular que contenen "start" i "finish", respectivament.
    // Post: Retorna un arbre T', amb la mateixa estructura que T, i amb un contingut
    //       que és diferencia de T només en els nodes intermitjos
    //       del camí més curt que ens porta des del node "start" fins al node "finish".
    //       Si el camí tira cap amunt en un cert node, llavors aquest node té "up".
    //       Si el camí baixa cap a l'esquerra en un cert node, llavors aquest node té "left".
    //       Si el camí baixa cap a la dreta en un cert node, llavors aquest node té "right".
    BinTree<string> showPath(BinTree<string> t);

Fixeu-vos que l'enunciat d'aquest exercici ja ofereix uns fitxers que
haureu d'utilitzar per a compilar: `main.cc, BinTree.hh, showPath.hh`.
Us falta crear el fitxer `showPath.cc` amb els corresponents `includes`
i implementar-hi la funció anterior. Només cal que pugeu `showPath.cc`
al jutge.

## Entrada

La primera linia de l'entrada descriu el format en el que es descriuen
els arbres, o bé INLINEFORMAT o bé VISUALFORMAT. Després venen un nombre
arbitrari de casos. Cada cas consisteix en una descripció d'un arbre
binari d'strings. Fixeu-vos en que el programa que us oferim ja
s'encarrega de llegir aquestes entrades. Només cal que implementeu la
funció abans esmentada.

## Sortida

Per a cada cas, la sortida conté la corresponent sortida de la funció.
Fixeu-vos en que el programa que us oferim ja s'encarrega d'escriure
aquesta sortida. Només cal que implementeu la funció abans esmentada.

## Observació

La vostra solució ha de treballar amb BinTree, tot i que podeu utilitzar
altres estructures de dades presentades al curs com a element de suport
(tot i que realment no és necessari).

Avaluació sobre 10 punts:

- Solució lenta: 5 punts.

- solució ràpida: 10 punts.

Entenem com a solució ràpida una que és correcta, de cost lineal i capaç
de superar els jocs de proves públics i privats. Entenem com a solució
lenta una que no és ràpida, però és correcta i capaç de superar els jocs
de proves públics.

## Informació del problema

Autoria: PRO2

Generació: 2026-01-25T17:33:44.375Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
