# Avaluar expressions amb divisió (PRO2)

**INTRODUCCIÓ:**

En aquest exercici considerarem arbres que representen expressions sobre
els operadors binaris `+,-,*,/`, i sobre operands naturals. Per exemple,
el següent arbre representa l'expressió `3+4/2-5`.

              -
              |
          ---- ----
         |         |
         +         5
         |
     ---- ----
    |         |
    3         /
              |
          ---- ----
         |         |
         4         2

Alhora d'avaluar una divisió, interpretem la divisió entera que ens
ofereix C++. Noteu que, en particular, $(-5)/2=-2$, contradient la
definició que trobem habitualment en llibres de matemàtiques.

Noteu també que la divisió per $0$ no està definida, i això ho haurem de
tenir en compte en resoldre l'exercici.

**EXERCICI:**

Implementeu una funció que, donat un arbre binari d'strings que
representa una expressió correcta sobre naturals i operadors binaris
`+,-,*,/`, retorna la seva avaluació i un indicador de si s'ha produït
un error de divisió per 0, tot mitjançant paràmetres per referència.
Aquesta és la capcelera:

    // Pre:  t és un arbre no buit que representa una expressió correcta
    //       sobre els naturals i els operadors binaris +,-,*,/.
    //       Les operacions no produeixen errors d'overflow,
    //       però poden produïr error de divisió per 0.
    // Post: Si l'avaluació de l'expressió representada per t no produeix errors de divisió per 0, 
    //       llavors 'result' val l'avaluació d'aquesta expressió i 'error' val 'false'.
    //       En cas contrari, 'error' val 'true', i el valor de 'result' és irrellevant.
    void evaluate(BinTree<string> t, int &result, bool &error);

Aquí tenim un exemple de paràmetre d'entrada de la funció i els
corresponents valors de sortida:

    evaluate(/(+(1,2),-(5,2)), result, error) produces result=1, error=false

Fixeu-vos que l'enunciat d'aquest exercici ja ofereix uns fitxers que
haureu d'utilitzar per a compilar:
`main.cc, BinTree.hh, evaluate.hh, utils.hh, utils.cc`. Us falta crear
el fitxer `evaluate.cc` amb els corresponents `includes` i
implementar-hi la funció anterior. Valdrà la pena que utilitzeu algunes
de les funcions oferides a `utils.hh`. Haureu de compilar `main.cc`,
`utils.cc` i `evaluate.cc` combinadament. Només cal que pugeu
`evaluate.cc` al jutge.

## Entrada

La primera linia de l'entrada descriu el format en el que es descriuen
els arbres, o bé INLINEFORMAT o bé VISUALFORMAT. Després venen un nombre
arbitrari de casos. Cada cas consisteix en una descripció d'un arbre un
arbre binari que representa una expressió. Fixeu-vos en que el programa
que us oferim ja s'encarrega de llegir aquestes entrades. Només cal que
implementeu la funció abans esmentada.

## Sortida

Per a cada cas, la sortida conté la corresponent avaluació de l'arbre o
bé una indicació de que s'ha produït un error de divisió per 0 durant el
procès d'avaluar l'arbre. Fixeu-vos en que el programa que us oferim ja
s'encarrega d'escriure aquesta sortida. Només cal que implementeu la
funció abans esmentada.

## Observació

La vostra funció i subfuncions que creeu han de treballar només amb
arbres. Heu de trobar una solució **RECURSIVA** del problema.

## Informació del problema

Autoria: PRO2

Generació: 2026-01-25T17:33:34.464Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
