# Vectores normalizados

Un vector de puntos en el plano está *normalizado* si cumple todas las
siguiente condiciones:

1.  El vector contiene al menos dos elementos diferentes.

2.  La suma de todas las coordenadas $x$'s de los puntos del vector
    coincide con la suma de todas las coordenadas $y$'s de los puntos
    del vector.

3.  El baricentro de los puntos del vector no aparece en el vector.

Recordad que el baricentro de un conjunto de puntos es el punto $(x,y)$
del plano que tiene como coordenada $x$ el valor medio de las
coordenadas $x$'s de los puntos, y como coordenada $y$ el valor medio de
las coordenadas $y$'s de los puntos.

 \
Haced un programa que lea vectores de puntos en el plano y determine si
están normalizados o no.

Vuestro programa ha de utilizar la siguiente definición:

> **struct** Punto $\{$
>
> **double** x,y;
>
> $\}$;

y también ha de definir, implementar y utilizar la función:

> **bool** baricentro (**const** vector$<$Punto$>$& v, Punto& b);

que, dado un vector de puntos $v$, calcula en $b$ el baricentro de los
puntos de $v$, y devuelve un booleano que indica si $b$ está o no en el
vector $v$.

## Entrada

La entrada consiste en diversas líneas con secuencias. Cada secuencia
describe un vector de puntos mediante un natural $n>0$ y, a
continuación, $n$ pares de reales $x_1$, $y_1$, $\ldots$, $x_n$, $y_n$
que describen las coordenadas de los $n$ puntos que forman el vector.

## Salida

Para cada vector de puntos, la salida está formada por el baricentro de
sus puntos y un indicador de si el vector es o no un vector normalizado.
En caso de que no lo sea, la salida indica cuál de las tres propiedades
de la definición es la primera que [no]{.smallcaps} se cumple.

 \
Seguid el formato especificado en los ejemplos.

 \

Los números reales se han de escribir con 2 cifras decimales. Utilizad:

> cout.setf(ios::fixed);
>
> cout.precision(2);

## Información del problema

Autoría: Unknown\
Traducción: Maria J. Blesa

Generación: 2026-01-25T17:32:37.557Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
