# Normalized vectors

A vector of points on the plane is *normalized* if all the following
three conditions hold:

1.  The vector contains at least two different elements.

2.  The sum of all the $x$-coordinates of the points in the vector
    equals the sum of all the $y$-coordinates of the points in the
    vector.

3.  The barycenter of the points in the vector does not belong to the
    vector.

Recall that the barycenter of a set of points is the point $(x,y)$ of
the plane which has the average value of the $x$-coordinates of the
points as $x$-coordinate, and the average value of the $y$-coordinates
of the points as $y$-coordinate.

 \
Make a program that reads vectors of points on the plane and determines
whether they are normalized or not.

Your program must use the following definition:

> **struct** Point $\{$
>
> **double** x,y;
>
> $\}$;

and it must also define, implement and use the following function:

> **bool** barycenter (**const** vector$<$Point$>$& v, Point& b);

which, given a vector of points $v$, it computes in $b$ the barycenter
of the points in $v$ and returns a boolean indicating whether $b$ is to
be found in $v$ or not.

## Input

The input consists in several lines with sequences. Each sequence
describes a vector of points by means of a natural number $n>0$, which
is followed by $n$ pairs of real numbers $x_1$, $y_1$, $\ldots$, $x_n$,
$y_n$ describing the coordinates of the $n$ points in the vector.

## Output

For each vector of points, the output indicates the barycenter of its
points and whether the vector is a normalized one or not. In case the
vector is not normalized, the output indicates which of the three
required properties of the definition is the first one [not]{.smallcaps}
holding.

 \
You are asked to follow the output format of the examples.

 \

Real numbers must be written using 2 digits in their fractional part.
Use:

> cout.setf(ios::fixed);
>
> cout.precision(2);

## Problem information

Author: Unknown\
Translator: Maria J. Blesa

Generation: 2026-01-25T17:32:42.050Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
