# Vectors normalitzats

Un vector de punts al pla está *normalitzat* si compleix totes les
següents condicions:

1.  El vector conté almenys dos elements diferents.

2.  La suma de totes les coordenades $x$'s dels punts al vector
    coincideix amb la suma de totes les coordenades $y$'s dels punts al
    vector.

3.  El baricentre dels punts del vector no apareix al vector.

Recordeu que el baricentre d'un conjunt de punts és un punt $(x,y)$ al
pla que té com a coordenada $x$ el valor mitjà de les coordenades $x$'s
dels punts, i com a coordenada $y$ el valor mitjà de les coordenades
$y$'s dels punts.

 \
Feu un programa que llegeixi vectors de punts al pla i determini si
estan o no normalitzats.

El vostre programa ha de fer servir la següent definició:

> **struct** Punt $\{$
>
> **double** x,y;
>
> $\}$;

i també ha de definir, implementar i utilitzar la funció:

> **bool** baricentre (**const** vector$<$Punt$>$& v, Punt& b);

que, donat un vector de punts $v$, calcula a $b$ el baricentre dels
punts de $v$, i retorna un booleà indicant si $b$ és o no al vector $v$.

## Entrada

L'entrada consisteix en diverses línies amb seqüències. Cada seqüència
descriu un vector de punts mitjançant un natural $n>0$ i, a continuació,
$n$ parells de reals $x_1$, $y_1$, $\ldots$, $x_n$, $y_n$ que descriuen
les coordenades dels $n$ punts que formen el vector.

## Sortida

Per a cada vector de punts, la sortida està formada pel baricentre dels
seus punts i un indicador de si és o no un vector normalitzat. En cas
que no ho sigui, la sortida indica quina de les tres propietats de la
definició és la primera que [no]{.smallcaps} es compleix.

 \
Seguiu el format especificat als exemples.

 \

Els nombres reals cal escriure'ls amb 2 xifres decimals. Feu servir:

> cout.setf(ios::fixed);
>
> cout.precision(2);

## Informació del problema

Autoria: Maria J. Serna i Maria J. Blesa

Generació: 2026-01-25T17:32:46.542Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
