# Mensaje oculto

Maria y Josep tienen que intercambiar a menudo información y no desean
que el resto de sus compañeros de despacho puedan enterarse. Para ello
han acordado un sistema simple de cifrado que oculta el mensaje dentro
de una matriz cuadrada de letras mayúsculas. Teneís que hacer un
programa que reciba una matriz con un mensaje oculto y lo escriba.

Para recuperar el mensaje teneís que seguir un recorrido (cíclico) de la
matriz por diagonales y en sentido creciente (ver figura) y tener en
cuenta algunos parámetros adicionales.

- $\ell$ el número de caracteres que se necesita extraer de la matriz.

- $p$ la posición inicial de la primera letra del mensaje codificado.

- $d$ el número de posiciones que hay que saltar (en el recorrido por
  diagonales) para encontrar la siguiente letra del mensaje oculto.

![image](RecD){width="10cm"}

Además sabemos que el mensaje original está formado por palabras que
contienen exclusivamente letras mayúsculas y que el blanco que separan
dos palabras se ha reescrito, antes de ocultar el mensaje, con la
combinación `XX`.

Vuestro programa debe utilizar la siguiente definición:

> **struct** Coord $\{$
>
> **int** x,y;
>
> $\}$;

y también tiene que definir, implementar y utilizar la función:

> **Coord** siguienteD (**const Coord**& p, int n);

que, dadas las coordenadas de una posición en una matriz cuadrada
$n\times n$, calcula la posición siguiente de acuerdo con un recorrido
por diagonales en sentido creciente. Por ejemple si $n=8$, la función
con $p=(7,7)$ ha de devolver las coordenades $(0,0)$, con $p=(0,7)$,
$(7,1)$ y con $p=(2,1)$, $(1,2)$.

## Entrada

La entrada consiste en diversas líneas conteniendo información sobre
matrices con mensajes ocultos. La descripción de una matriz se inicia
con una línea con 5 valores enteros, $n$, $d$, $\ell$ ($d \ell < n^2$) y
$f$, $c$, ($p =(f,c)$ con $0\leq f,c< n$) que determinan los parámetros.
Seguidos de $n$ líneas describiendo la matriz $M$ que oculta el mensaje
por filas.

## Salida

Para cada matriz la salida está formada por el mensaje que oculta,
escrito con las palabras separadas por un blanco. Podeis asumir que la
combinación `XX` nunca forma parte de una palabra del mensaje original,
que la combinación `XXX` nunca aparece en un mensaje oculto que el
mensaje oculto siempre tiene como mínimo una palabra.

 \
Seguid el formato especificado en los ejemplos.

 \

## Información del problema

Autoría: Unknown\
Traducción: Maria J. Serna

Generación: 2026-01-25T17:31:20.804Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
