# Hidden menssage

Josep and Maria often need to exchange information and do not want the
rest of their office mates to know. For this they have agreed a simple
cipher that hides the message into a square matrix of capital letters.
You have to make a program that receives a matrix with a hidden message
and writes the hidden message.

To retrieve the message you have to follow a (cyclic) traversal by
diagonals of the matrix in ascending order (see figure) and take into
account some additional parameters.

- $\ell$ the number of characters you need to remove the matrix.

- $p$ the starting position of the first letter of the encoded message.

- $d$ the number of positions to be skipped (in the traversal in
  ascending diagonal order) to find the next letter of the hidden
  message.

![image](RecD){width="10cm"}

We also know that the original message is composed of words containing
only uppercase letters and that the white space separating two words has
been rewritten, before hiding, with the combination `XX`.

Your program must use the following definition:

> **struct** Coord $\{$
>
> **int** x,y;
>
> $\}$;

and also has to define, implement and use the function:

> **Coord** nextD (**const Coord**& p, int n);

that, given the coordinates of a position in an square matrix
$n \times n$, computes the next position according to a traversal in
ascending diagonal order. For example when $n=8$, the function when
$p=(7,7)$ has to return the coordinates $(0,0)$, when $p=(0,7)$, $(7,1)$
and when $p=(2,1)$, $(1,2)$.

## Input

The input consists of several lines containing information on arrays
with hidden messages. The description of a matrix begins with a line of
5 integers, $d$, $n$, $\ell$ ($d \ell < n^2$) y $f$, $c$, ($p =(f,c)$
with $0\leq f,c< n$) determining the parameters. Followed by $n$ lines
describing the matrix $M$ that hides the message by rows.

## Output

For each matrix, the output is formed by the hidden message, written
with words separated by a blank. You can assume that the combination
`XX` never forms part of a word in the original message, that the
combination `XXX` never occurs in a hidden message and that any message
has at least one word.

 \
Follow the format specified in the examples.

 \

## Problem information

Author: Unknown\
Translator: Maria J. Serna

Generation: 2026-01-25T17:31:24.901Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
