# Máxima puntuación

Supongamos que tenemos una matriz **`L`** de letras minúsculas, con $r$
filas y $c$ columnas, y otra matriz **`P`** de números enteros
positivos, también con $r$ filas y $c$ columnas. Dada una *string*
**`s`** podemos otorgar a esta *string* una determinada puntuación si
*aparece* en `L`, en función de los valores en las mismas posiciones de
`P`.

Por ejemplo, supongamos que `L` tiene 3 filas y 4 columnas:

    L = [['a','b','c','a'], 
         ['b','c','a','f'], 
         ['c','a','b','c']]

y `P`, también con 3 filas y 4 columnas:

    P = [[10,20,30,40], 
         [50,60,70,80], 
         [15,25,35,45]]

Decimos que una *string* *aparece* en `L` haciendo coincidir las letras
de la *string* con las posiciones de la matriz `L` de izquierda a
derecha o de arriba abajo (no sirve si aparece de derecha a izquierda o
de abajo arriba).

Así pues:

- La *string* `’abc’` aparece tres veces en `L`: a) primera fila,
  columnas 0, 1 y 2; b) tercera fila, columnas 1, 2 y 3, y c) primera
  columna, filas 0, 1 y 2. De acuerdo a los puntos especificados en `P`,
  la *string* `’abc’` obtiene 60 puntos en el caso a), 105 puntos en el
  caso b), y 75 puntos en el caso c).

- La *string* `’fc’` aparece sólo una vez, en la última columna, filas 1
  y 2. Aquí obtendrá 125 puntos.

- Finalmente, la *string* `’fa’` sencillamente no aparece.

Escribir una función **`max_punt(L,P)`** que, dada una matriz **`L`** de
letras minúsculas, con $r$ filas y $c$ columnas, y otra matriz **`P`**
de números enteros positivos, también con $r$ filas y $c$ columnas,
retorne *una función*.

Esta función retornada, llamémosla `fret`, es una función que tiene como
parámetro una *string* **`s`**, y debe retornar la máxima puntuación que
puede obtener `s`, si `s` aparece en `L`, o bien la *string* `’no’`, si
`s` no aparece en `L`.

## Entrada

La función tiene dos matrices con las mismas dimensiones (filas y
columnas) como parámetros.

## Salida

La función pedida debe retornar una función de una *string*, que
devuelve un número entero o *string* `’no’`.

## Observaciones

Una vez definida la función, al probarla en el REPL de Python debería
salir lo mismo que puede observar más abajo.

## Información del problema

Autoría: Jordi Delgado (basado en el problema P87801 de Salvador Roura)

Generación: 2026-01-25T23:00:21.183Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
