# Màxima puntuació

Suposem que tenim una matriu **`L`** de lletres minúscules, amb $r$
files i $c$ columnes, i una altra matriu **`P`** de nombres enters
positius, també amb $r$ files i $c$ columnes. Donada una *string*
**`s`** podem atorgar a aquesta *string* una determinada puntuació si
*apareix* a `L`, en funció dels valors a les mateixes posicions de `P`.

Per exemple, suposem que `L` té 3 files i 4 columnes:

    L = [['a','b','c','a'],
         ['b','c','a','f'],
         ['c','a','b','c']]

i `P`, també amb 3 files i 4 columnes:

    P = [[10,20,30,40],
         [50,60,70,80],
         [15,25,35,45]]

Mirem si una *string* *apareix* a `L` fent coincidir les lletres de
l'*string* amb les posicions de la matriu `L` d'esquerra a dreta o de
dalt a baix (no serveix si apareix de dreta a esquerra o de baix a
dalt).

Així doncs:

- L'*string* `’abc’` apareix tres cops a `L`: a) primera fila, columnes
  0, 1 i 2, b) tercera fila, columnes 1, 2 i 3, i c) primera columna,
  files 0, 1 i 2. D'acord als punts especificats a `P`, l'*string*
  `’abc’` obté 60 punts en el cas a), 105 punts al cas b), i 75 punts al
  cas c).

- L'*string* `’fc’` apareix només un cop, a la darrera columna, files 1
  i 2. Aquí obtindrà 125 punts.

- Finalment, l'*string* `’fa’` senzillament no apareix.

Escriure una funció **`max_punt(L,P)`** que, donada una matriu **`L`**
de lletres minúscules, amb $r$ files i $c$ columnes, i una altra matriu
**`P`** de nombres enters positius, també amb $r$ files i $c$ columnes,
retorni *una funció*.

Aquesta funció retornada, anomenem-la `fret`, és una funció que té com a
paràmetre una *string* **`s`**, i ha de retornar la màxima puntuació que
pot obtenir `s`, si `s` apareix a `L`, o bé l'*string* `’no’`, si `s` no
apareix a `L`.

## Entrada

La funció té dues matrius de les mateixes dimensions (files i columnes)
com a paràmetres.

## Sortida

La funció demanada ha de retornar una funció d'una *string*, que retorna
un nombre enter o l'*string* `’no’`.

## Observacions

Un cop definida la funció, en provar-la al REPL de Python us hauria de
sortir el mateix que podeu observar més avall.

## Informació del problema

Autoria: Jordi Delgado (basat en el problema P87801 de Salvador Roura)

Generació: 2026-01-25T23:00:17.209Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
