# Fibonacci

Design a sequential circuit that generates the Fibonacci series. The
circuit will represent the numbers with $n$ bits and will generate the
Fibonacci numbers $\textit{mod~} 2^n$. At each cycle, a new number must
be generated. The following waveform illustrates the behavior of the
circuit.\

::: center
![image](waveform.png){width="12cm"}
:::

The circuit must be designed to represent the numbers with 6 bits.

## Specification

``` verilog
module fibonacci(clk, rst, fib);
    input clk, rst;
    output [5:0] fib;
```

## Input

- `clk` is the clock signal.

- `rst` is the synchronous reset signal.

## Output

- `fib` is the Fibonacci number generated at each cycle.

## Problem information

Author: Jordi Cortadella

Generation: 2026-02-03T12:21:49.531Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
