# Columnas ordenadas de una matriz

Escribe una función llamada `columnasordenadas`. Dicha función recibirá
como único parámetro una matriz cuadrada de números enteros representada
como una lista de listas; la función devolverá un valor booleano.

El valor booleano devuelto deberá ser `True` si todas las columnas de la
matriz contienen sus elementos ordenados de menor a mayor. Para resolver
este problema correctamente, habrá que evaluar individualmente si los
elementos de cada columna están ordenados, y no será necesario comparar
elementos de diferentes columnas. Es posible que aparezcan elementos
repetidos, por tanto, consideraremos que una columna está ordenada si
todo elemento es menor o igual que el elemento siguiente. No es
necesario comprobar que la matriz es cuadrada, pero la función deberá
devolver el valor correcto para matrices cuadradas de orden 2 en
adelante.

Por ejemplo, para la matriz de entrada
`[[4, 3, 0], [5, 10, 0], [5, 12, 9]]`, el programa deberá devolver
`True`, porque las tres columnas están ordenadas. Para la matriz de
entrada `[[1, 4, 9], [2, 3, 10], [10, 11, 12]]`, el programa deberá
devolver `False` porque la segunda columna no está ordenada.

Para que tu función pueda ser evaluada correctamente por el juez en
línea, tu código deberá tener la siguiente forma:

``` python
import sys

def columnasordenadas(matriz):
...

M=eval(sys.stdin.readline().strip())
print(columnasordenadas(M))
```

## Entrada

(Si utilizas el fragmento de código definido más arriba, no debes
preocuparte por esto) Una línea que contendrá la matriz escrita en una
sola línea como si se tratara de código fuente Python.

## Salida

(Si utilizas el fragmento de código definido más arriba, no debes
preocuparte por esto) `True` si los elementos de todas las columnas
están ordenados de menor a mayor y `False` en caso contrario.

## Información del problema

Autoría: Víctor M. Sánchez Cartagena

Generación: 2026-01-25T20:00:11.903Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
