# Fracción continua raíz

Este enunciado sólo se visualiza correctamente en su versión pdf.

Todo número real se puede representar como el resultado de una fracción
continua.

Por ejemplo:

$$\displaystyle\frac{972}{421} = 
	2 + \displaystyle\frac{1}{3 + \displaystyle\frac{1}{4 + \displaystyle\frac{1}{5 + \displaystyle\frac{1}{6}}}}$$

Las fracciones continuas se representan como la lista de los valores
enteros sumados y el último denominador. En este caso sería \[2, 3, 4,
5, 6\]. Para número irracionales, la representación como fracción
continua es infinita.

Consecuentemente, toda raíz cuadrada se puede reescribir en forma de una
fracción continua (en el caso de las raíces la fracción puede ser
infinita y siempre tiene un cierto periodo a partir del cual se repiten
los valores).

Por ejemplo,la fracción continua periódica para $\sqrt{14}$ es:

$$\displaystyle\sqrt{14} = 
	3 + \displaystyle\frac{1}{1 + \displaystyle\frac{1}{2 + \displaystyle\frac{1}{1 + \displaystyle\frac{1}{6}}}}$$

El prodimiento para calcular el periodo de la fracción continua de una
raíz cuadrada es el siguiente:

$a0 = int(\displaystyle\sqrt{14}) = 3; r1 = \displaystyle\frac{1}{\sqrt{14}-3} = 1.3483314773547883$

$a1 = int(r1) = 1; r2 = \displaystyle\frac{1}{r1-a1} = 2.8708286933869704$

$a2 = int(r2) = 2; r3 = \displaystyle\frac{1}{r2-a2} = 1.1483314773547886$

$a3 = int(r3) = 1; r4 = \displaystyle\frac{1}{r3-a3} = 6.741657386773927$

$a4 = int(r4) = 6$; final, se detecta el periodo al encontrar un valor
igual al doble del primero

La lista que codifica el periodo de la fracción continua de 14 es:

\[3, 1, 2, 1, 6\]

Se pide diseñar la función $fraccion\_continua\_raiz$ que, dado un valor
entero $n$, devuelva una lista que codifique el periodo de la fracción
continua de la raiz de $n$. El valor de entrada $n$ es un entero
positivo que no puede ser un cuadrado; no es necesario que la función
tenga en cuenta ese caso.

## Ejemplo de sessión

## Información del problema

Autoría: InfBesos

Generación: 2026-01-25T17:18:33.707Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
