# ¿Es hermítica?

Recordemos que un número *complejo* $a+bi$ tiene una parte real ($a$) y
una parte imaginaria ($b$). Diremos que el *conjugado* de un número
complejo $a+bi$ es sencillamente el mismo número pero con la parte
imaginaria cambiada de signo. Así pues, si $c = a+bi$, el conjugado de
$c$, que llamaremos $c^{\ast}$, es $a-bi$. Nosotros representaremos los
números complejos con tuplas de dos elementos: $a+bi$ será representado
como **`(a,b)`**

Una matriz $M$ cuadrada (con tamaño $n \times n$) de números complejos
es *hermítica* si es igual a su transpuesta-conjugada: Para todo
$1 \leq i,j \leq n$, tenemos $M_{ij}=M^{\ast}_{ji}$. O, dicho de otro
modo, si transponemos $M$ (cambiamos filas por columnas) y hacemos el
conjugado de todos sus elementos, la matriz $M$ no cambia.

Escribir una función **`es_hermitica(m)`** que, dada una matriz $m$
cuadrada de números complejos, retorne **`True`** si $m$ es hermítica, y
**`False`** en caso contrario. Fijémonos en que tal como hemos dicho más
arriba, $m$ *será una matriz cuadrada de tuplas de dos elementos*.

Ejemplo de matriz hermítica:

$$\left[\begin{array}{ccc}
{-1} & {1-2i} & {0} \\
{1+2i} & {0} & {-i} \\
{0} & {i} & {1}
\end{array}\right]$$

que nosotros representaremos así:

    m = [[(-1,0),(1,-2),(0, 0)],
         [(1, 2),(0, 0),(0,-1)],
         [(0, 0),(0, 1),(1, 0)]]

## Entrada

La función tiene una matriz cuadrada de tuplas de dos elementos que
representan números complejos.

## Observaciones

Una matriz hermítica con números reales como elementos es sencillamente
una matriz simétrica.

Una vez definida la función, al probarla en el REPL de Python debería
salir lo mismo que puede observar más abajo.

## Información del problema

Autoría: Jordi Delgado

Generación: 2026-01-25T22:53:59.934Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
