# És hermítica?

Recordem que un nombre *complex* $a+bi$ té una part real ($a$) i una
part imaginària ($b$). Direm que el *conjugat* d'un nombre complex
$a+bi$ és senzillament el mateix nombre però amb la part imaginària
canviada de signe. Així doncs, si $c = a+bi$, el conjugat de $c$, que
anomenarem $c^{\ast}$, és $a-bi$. Nosaltres representarem els nombres
complexos amb tuples de dos elements: $a+bi$ serà representat com
**`(a,b)`**

Una matriu $M$ quadrada (amb mida $n \times n$) de nombres complexos és
*hermítica* si és igual a la seva transposta-conjugada: Per a tot
$1 \leq i,j \leq n$, tenim $M_{ij}=M^{\ast}_{ji}$. O, dit d'una altra
manera, si transposem $M$ (canviem files per columnes) i fem el conjugat
de tots els seus elements, la matriu $M$ no canvia.

Escriure una funció **`es_hermitica(m)`** que, donada una matriu $m$
quadrada de nombres complexos, retorni **`True`** si $m$ és hermítica, i
**`False`** en cas contrari. Fixem-nos que tal com hem dit més amunt,
$m$ *serà una matriu quadrada de tuples de dos elements*.

Exemple de matriu hermítica:

$$\left[\begin{array}{ccc}
{-1}   & {1-2i} & {0} \\
{1+2i} & {0}    & {-i} \\
{0}    & {i}    & {1} 
\end{array}\right]$$

que nosaltres representarem així:

    m = [[(-1,0),(1,-2),(0, 0)],
         [(1, 2),(0, 0),(0,-1)],
         [(0, 0),(0, 1),(1, 0)]]

## Entrada

La funció té una matriu quadrada de tuples de dos elements que
representen nombres complexos.

## Observacions

Una matriu hermítica amb nombres reals com a elements és senzillament
una matriu simètrica.

Un cop definida la funció, en provar-la al REPL de Python us hauria de
sortir el mateix que podeu observar més avall.

## Informació del problema

Autoria: Jordi Delgado

Generació: 2026-01-25T22:53:55.261Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
