# Reading Addition Trees

Addition trees are binary trees where only the leaves can store
arbitrary numbers (float's in our case). Values associated to internal
nodes get computed according to a fixed rule: the sum of the values
associated to the subtrees (thus, in some applications, it may not be
necessary to actually store the value). Note that there are no empty
addition trees.

Addition trees are the main combinatorial structure behind Huffman codes
(see https://jutge.org/problems/P62266 for more). They are also a very
close relative of the Product Trees of
https://jutge.org/problems/P30012.

We describe addition trees in preorder as indicated below. Write a
program that reads such a description and prints the preorder, inorder
and postorder traversals of the tree read. (The pdf version of the
statement of https://jutge.org/problems/P62266 graphically depicts one
of the public test trees below.)

## Input

Addition trees are described here in preorder as follows: for leaves,
the corresponding float is given, whereas for internal nodes only the
character '+' is written. All these tokens are space-separated and might
come distributed arbitrarily along several lines.

## Output

Three sequences of floats, as obtained by preorder, inorder, and
postorder of the tree described by the input. Print each float with 4
decimal places.

## Problem information

Author: José Luis Balcázar

Generation: 2026-01-25T17:15:45.696Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
