# Camí més llarg en un arbre

Implementeu una funció **RECURSIVA** que, donat un arbre binari
d'enters, retorna la llista de valors que es troben des de l'arrel
seguint el camí més llarg de l'arbre. En cas que hi hagi varis camins
màxims, s'haurà d'escollir el camí que va el més a l'esquerra possible.
Aquesta és la capcelera:

    // Pre:
    // Post: Retorna la llista d'elements que es troben a t, baixant des de l'arrel i
    //       seguint el camí més llarg. En cas de varis camins màxims,
    //       escull el de més a l'esquerra.
    list<int> longestLeftmostPath(BinTree<int> t);

Aquí tenim un exemple de paràmetre d'entrada de la funció i la
corresponent sortida:

    longestLeftmostPath(        3        ) => [3,3,2,1]
                                |
                         ------- -------
                        |               |
                        1               3
                        |               |
                         ----       ----
                             |     |
                             5     2
                                   |
                               ---- ----
                              |         |
                              1         7

Fixeu-vos que l'enunciat d'aquest exercici ja ofereix uns fitxers que
haureu d'utilitzar per a compilar:
`main.cc, BinTree.hh, longestLeftmostPath.hh`. Us falta crear el fitxer
`longestLeftmostPath.cc` amb els corresponents `includes` i
implementar-hi la funció anterior. Només cal que pugeu
`longestLeftmostPath.cc` al jutge.

## Entrada

La primera linia de l'entrada descriu el format en el que es descriuen
els arbres, o bé INLINEFORMAT o bé VISUALFORMAT. Després venen un nombre
arbitrari de casos. Cada cas consisteix en una descripció d'un arbre un
arbre binari d'enters. Fixeu-vos en que el programa que us oferim ja
s'encarrega de llegir aquestes entrades. Només cal que implementeu la
funció abans esmentada.

## Sortida

Per a cada cas, la sortida conté el corresponent camí més llarg i més a
l'esquerra de l'arbre. Fixeu-vos en que el programa que us oferim ja
s'encarrega d'escriure aquesta sortida. Només cal que implementeu la
funció abans esmentada.

## Observació

La vostra funció i subfuncions que creeu han de treballar només amb
arbres. Heu de trobar una solució **RECURSIVA** del problema.

Molt possiblement, una solució directa serà lenta, i necessitareu crear
alguna funció recursiva auxiliar per a produïr una solució més eficient
capaç de superar tots els jocs de proves. En particular, sembla
convenient precalcular abans l'arbre d'alçades corresponent a l'arbre
d'entrada, tot i que també pot passar que el compilador optimitzi bé una
solució aparentment més lenta.

## Informació del problema

Autoria: PRO2

Generació: 2026-01-25T17:15:05.966Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
