# Spiral Pattern

On a square grid, we start in (0,0) and we draw a spiral path. Then, on
this spiral path, we mark one square with the first color, then two
squares with the second color, three squares with the third color, etc.
To limit the number of colors, we pick a number $k \in \{2,3\}$ (these
values give the prettiest results) and use only $k$ colors (we go back
to color 1 instead of $k+1$). The results are shown on the pictures.

::: center
![image](spiral2s.eps){width="5cm"} ![image](spiral2.eps){width="5cm"}
![image](spiral3.eps){width="5cm"}
:::

We would like to quickly calculate which color will be used on a square
grid with given coordinates.

## Input

Each line contains three integers $k,x,y$, where $k \in \{2,3\}$ and
$|x|, |y| \leq 1000000000$.

Input ends with a line containing 0 0 0.

## Output

For each $k,x,y$ output the color of point $(x,y)$, as a number from $1$
to $k$. Positive $x$ coordinates go rightwards, and positive $y$
coordinates go upwards.

## Problem information

Author: Eryk Kopczynski

Generation: 2026-01-25T22:53:10.509Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
