# Estudiants que s'inscriuen en assignatures

Heu d'implementar un programa que manega estudiants, assignatures, i
quins estudiants estan inscrits en quines assignatures.

L'entrada consistirà en una llista de comandes. Entre elles, hi ha
comandes que matriculen un estudiant en una assignatura. Per exemple:

    ENROLL maria.lapuente Algebra
    ENROLL maria.lapuente OperatingSystems
    ENROLL john.smith Programming
    ENROLL nuria.margalef Calculus
    ENROLL laura.venture Algebra
    ENROLL maria.lapuente Calculus
    ENROLL laura.venture Programming
    ENROLL maria.lapuente Programming
    ENROLL nuria.margalef Programming

També hi ha comandes que donen de baixa un estudiant en una assignatura.
Per exemple:

    QUIT maria.lapuente Programming
    QUIT laura.venture Algebra

També hi ha comandes que demanen la llista d'assignatures, en ordre
lexicogràfic, en les quals un estudiant donat està matriculat. Per
exemple:

    SUBJECTSOFSTUDENT maria.lapuente
    SUBJECTSOFSTUDENT john.smith
    SUBJECTSOFSTUDENT nuria.margalef

Incloent les comandes prèvies de matricular i donar de baixa, la sortida
seria aquesta:

    Algebra Calculus OperatingSystems
    Programming
    Calculus Programming

També hi ha comandes que demanen la llista de persones, en ordre
lexicogràfic, que estan matriculades en una assignatura. Per exemple:

    STUDENTSOFSUBJECT Algebra
    STUDENTSOFSUBJECT Calculus
    STUDENTSOFSUBJECT Programming

Incloent les comandes prèvies de matricular i donar de baixa, la sortida
seria aquesta:

    maria.lapuente
    maria.lapuente nuria.margalef
    john.smith laura.venture nuria.margalef

**Observació:** Podeu seguir l'enfoc que considereu oportú, i podeu
utilitzar qualsevol de les classes presentades al curs (**string,
vector, stack, queue, list, map, set**) de la manera que considereu
oportuna. Però tingueu en compte que la vostra elecció pot afectar a
l'eficiència de la vostra solució, i per tant al fet de poder superar
tots els jocs de proves o només els públics (cosa que us deixarà amb la
meitat de la nota).

## Entrada

Cada linia de l'entrada consisteix en una instrucció del següent tipus,
a on `student` i `subject` es poden llegir com strings no buits
qualsevols, i tenen menys de 20 caràcters:

- `ENROLL student subject`

- `QUIT student subject`

- `SUBJECTSOFSTUDENT student`

- `STUDENTSOFSUBJECT subject`

Podem suposar que les entrades son correctes: mai s'afegeix un estudiant
a una assignatura si ja hi és, i mai es dona de baixa un estudiant d'una
assignatura si no hi és.

## Sortida

Per a cada instrucció `SUBJECTSOFSTUDENT student`, s'escriurà una línia
per la sortida amb la llista d'assignatures actuals de l'estudiant,
separada per espais en blanc.

Per a cada instrucció `STUDENTSOFSUBJECT subject`, s'escriurà una línia
per la sortida amb la llista d'estudiants actuals de l'assignatura,
ordenada lexicogràficament, i separada per espais en blanc.

## Observació

Avaluació sobre 10 punts:

- Solució lenta: 5 punts.

- solució ràpida: 10 punts.

Entenem com a solució ràpida una que és correcta, de cost $n\log(n)$ o
inferior, i capaç de superar els jocs de proves públics i privats.
Entenem com a solució lenta una que no és ràpida, però és correcta i
capaç de superar els jocs de proves públics.

## Informació del problema

Autoria: PRO2

Generació: 2026-01-25T17:08:38.563Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
