# Afegir els propis elements d'una llista al final i en ordre invers

Heu d'implementar una funció que rep una llista d'enters
$[x_0,x_1,x_2,\ldots,x_{n-2},x_{n-1}]$ com a paràmetre per referència.
La funció haurà d'insertar, al final de la llista, els elements que
contenia inicialment però en ordre invers. És a dir, la funció retorna
la llista:
$$[x_0,x_1,x_2,\ldots,x_{n-2},x_{n-1},x_{n-1},x_{n-2},\ldots,x_2,x_1,x_0]$$

**Important:** heu de garantir que els elements que la llista contenia
inicialment han de quedar inalterats i ocupant les posicions del
principi. En particular, la funció no els pot eliminar i tornar a afegir
després.

Aquesta és la capcelera:

    // Pre: Sigui [x0,x1,x2,...,x{n-1}] el valor inicial de l.
    // Post: El valor de l és [x0,x1,x2,...,x{n-1},x{n-1},...,x2,x1,x0].
    //       A més a més, els elements inicials de la llista han persistit i
    //       no han canviat de valor, i ocupen les posicions del principi.
    void appendReverseOrder(list<int> &l);

Aquí tenim un exemple de comportament de la funció:

    insertSumsPrefixes([2,3,1]) = [2,3,1,1,3,2]

## Observació

Només cal enviar el procediment demanat; el programa principal serà
ignorat.

## Observació

La vostra funció i subfuncions que creeu han de treballar només amb
llistes. Avaluació sobre 10 punts:

- Solució lenta: 5 punts.

- solució ràpida: 10 punts.

Entenem com a solució ràpida una que és correcta, de cost lineal i capaç
de superar els jocs de proves públics i privats. Entenem com a solució
lenta una que no és ràpida, però és correcta i capaç de superar els jocs
de proves públics.

Una solució que elimina els elements originals de la llista i els torna
a afegir més tard rebrà un 0.

## Informació del problema

Autoria: PRO2

Generació: 2026-01-25T17:08:01.903Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
