# Intersecció de taules de dispersió amb sinònims encadenats indirectes

Donada la classe $dicc$ que permet gestionar diccionaris amb claus
enteres, cal implementar els mètodes:

        // Pre:  Cert
        // Post: Insereix la clau k en el diccionari. Si ja hi era, no fa res.
        void insereix(const int &k);

        // Pre:  El diccionari res està buit
        // Post: Omple res amb la intersecció entre el p.i. i d2
        void interseccio(const dicc &d2, dicc &res) const;

Els diccionaris s'implementen amb taules de dispersió amb sinònims
encadenats indirectes. Les llistes de sinònims estan ordenades per la
clau.

Cal enviar a jutge.org la següent especificació de la classe $dicc$ i la
implementació dels mètodes dins del mateix fitxer (la resta de mètodes
públics ja estan implementats).

    #include <iostream>
    using namespace std;
    typedef unsigned int nat;

    class dicc {
      // Taula de dispersió sinònims encadenats indirectes
      // Les llistes de sinònims estan ordenades per clau
      public:
        // Constructora per defecte. Crea un diccionari buit.
        dicc();

        // Destructora
        ~dicc();

        // Retorna quants elements (claus) té el diccionari.
        nat quants() const;

        // Impressió per cout de totes les claus del diccionari segons l'ordre
        // en que estan a cadascuna de les llistes encadenades indirectes
        void print() const;

        // Pre:  Cert
        // Post: Insereix la clau k en el diccionari. Si ja hi era, no fa res.
        void insereix(const int &k);

        // Pre:  El diccionari res està buit
        // Post: Omple res amb la intersecció entre el p.i. i d2
        void interseccio(const dicc &d2, dicc &res) const;

      private:
        struct node_hash {
          int _k;           // Clau
          node_hash* _seg;
        };
        node_hash **_taula; // Taula amb punters a les llistes de sinònims
        nat _M;             // Mida de la taula
        nat _quants;        // Nº d'elements guardats al diccionari

        static long const MULT = 31415926;

        // Calcula un valor de dispersió entre 0 i LONG\_MAX a partir de k
        static long h(int k);

        // Destrueix la llista de nodes apuntats per p
        static void esborra_nodes(node_hash *p);

        // Aquí va l'especificació dels mètodes privats addicionals
    };

    // Aquí va la implementació dels mètodes públics insereix, interseccio i
    // dels mètodes privats addicionals
    };

Degut a que jutge.org només permet l'enviament d'un fitxer amb la
solució del problema, en el mateix fitxer hi ha d'haver l'especificació
de la classe i la implementació dels mètodes $insereix$ i $interseccio$
(el que normalment estarien separats en els fitxers $.hpp$ i $.cpp$).

Per testejar la classe disposes d'un programa principal que llegeix
elements i els insereix en un diccionari, desprès fa el mateix en un 2on
diccionari i finalment crida el mètode $interseccio$ per calcular la
intersecció dels dos diccionaris llegits.

## Entrada

L'entrada conté dues línies amb enters separats amb espais. Cada línia
conté els elements a inserir en un diccionari buit.

## Sortida

Escriu el contingut de 3 diccionaris: el 1er diccionari llegit, el 2on
diccionari llegit i el diccionari intersecció dels dos primers. Per cada
diccionari es mostra en diferents línies la quantitat d'elements que té
i els elements que conté cadascuna de les llistes de sinònims encadenats
indirectes (els elements de cada llista apareixen separats amb un espai
i en el mateix ordre en que es guarden).

## Observació

Per calcular el valor de dispersió utilitza el mètode $h$ que ja està
implementat i que permet calcular un valor de dispersió entre $0$ i
$LONG\_MAX$ (el valor long int més gran que permet el compilador) a
partir d'una clau entera.

En aquest exercici s'ha limitat la mida de la taula de dispersió $\_M$ a
$13$. En un cas real aquest valor seria molt més gran i/o
s'implementaria la tècnica de redispersió per tal que la mida s'anés
adaptant a les necessitats de cada moment.

Només cal enviar la classe requerida i la implementació dels mètodes
$insereix$ i $interseccio$. Pots ampliar la classe amb mètodes privats.
Segueix estrictament la definició de la classe de l'enunciat.

## Informació del problema

Autoria: Jordi Esteve

Generació: 2026-01-25T17:07:25.086Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
