cua::cua() : _ult(nullptr), _long(0) {   
}

cua::~cua() {
  if (_ult != nullptr) {
    node* fi = _ult;
    _ult = _ult->seg;
    while (_ult != fi) {
      node* aux = _ult;
      _ult = _ult->seg;
      delete aux;
    }
    delete(_ult);
  }
}

void cua::encuar(const int &x) {
  node* p = new(node); 
  try {
    p->info = x;
  } catch (const string& ex) {
    delete p;
    throw;
  }
  if (_ult == nullptr) {
    p->seg = p;  // cua amb un únic element que s'apunta 
  }              // a sí mateix
  else {
    p->seg = _ult->seg;
    _ult->seg = p;
  }
  _ult = p;
  _long++;
}

void cua::desencuar() { 
  if (_ult==nullptr) {
    throw CuaBuida;
  }
  node* p = _ult->seg;
  if (p == _ult) {
    _ult = nullptr; // desencuem una cua que tenia un únic 
  }              // element
  else {  
    _ult->seg = p->seg;
  }
  delete(p);
  _long--;
}

const int& cua::primer() const { 
  if (_ult==nullptr) { 
    throw CuaBuida;
  }
  return (_ult->seg->info);
}

bool cua::es_buida() const {  
  return (_ult==nullptr);
}

nat cua::longitud() const {
  return _long;
}


int main() {
  string linea;
  while (getline(cin, linea)) {
    cua c;
    istringstream ss(linea);
    int n;
    while (ss >> n) {
      c.encuar(n);
    }
    c.ordena();

    cout << c.longitud() << " [";
    while (not c.es_buida()) {
      if(c.longitud() == 1)
        cout << c.primer();
      else
        cout << c.primer() << " ";
      c.desencuar();
    }
    cout << "]" << endl;
  }
  return 0;
}
