# Funció de Distribució Acumulativa Gaussiana

La funció de densitat de probabilitat normal (Gaussiana) estàndard es
caracteritza per la famosa corba en forma de campana i ve definida per
la fórmula:

$$\phi(x) = \frac{e^{-x^2/2}}{\sqrt(2\pi)}.$$

La funció de distribució acumulativa normal (Gaussiana) estàndard
$\Phi(z)$ es defineix com l'àrea sota la corba definida per sobre de
l'eix $x$ i a l'esquerra de la línia vertical $x = z$.

Donada la mitjana $\mu$ i la desviació estàndard $\sigma$ d'un conjunt
de dades, el percentatge d'elements del conjunt amb valors inferiors a
un valor determinat $z$ s'aproxima estretament a la funció:

$$\Phi(z, \mu, \sigma) = \Phi\left(\frac{z-\mu}{\sigma}\right).$$

Com que aquesta funció no està disponible al mòdul matemàtic de Python
(verificar) us demanem que escriviu un programa que desenvolupi la seva
implementació sabent que es pot aproximar mitjançant la sèrie:

$$\Phi(z)= 1/2 + \phi(z)(z + z^3/3 + z^5/(3*5) + z^7/(3*5*7) + \ldots).$$

Seguiu aquesta aproximació fins que la diferència entre dos termes
consecutius de la sèrie no sigui perceptible pel vostre programa.

## Entrada

L'entrada son tres valors reals $z$, $\mu$ i $\sigma$.

## Sortida

Cal escriure per pantalla el resultat de calcular la funció de
distribució acumulativa gaussiana per als valors $z$,$\mu$ i $\sigma$ de
l'entrada utilitzant l'aproximació donada a l'enunciat.

## Observació

Aquest problema s'ha de programar obligatòriament en Python.

## Informació del problema

Autoria: Amalia Duch

Generació: 2026-01-25T19:54:26.414Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
