# Energy-efficient heating-cooling system

Design a circuit that controls a heating-cooling system of a room that
has a remotely-controlled window. The system has four temperature
sensors: two inside the room and two outside. The sensors inside the
room indicate whether the temperature is too high (`hot_in`=1) or too
cold (`cold_in`=1). The sensors outside the room indicate whether the
temperature is sufficiently hot (`hot_out`=1) or cold (`cold_out`=1) to
acclimatize the room.

The control system must save as much energy as possible, opening the
window (`open_window`=1) when the outside temperature can be used to
acclimatize the room. In case the outside temperature is not
appropriate, the cooler of the heater must be activated.

Note that `hot_in` and `cold_in` can never be at 1 simultaneously.
Similarly for `hot_out` and `cold_out`.

## Specification

``` verilog
module heater_cooler_window (hot_in, cold_in, hot_out, cold_out,
                             heater, cooler, open_window);
    input hot_in, cold_in, hot_out, cold_out;
    output heater, cooler, open_window;
```

## Input

- `hot_in` is the input that indicates when the inside temperature is
  too hot.

- `cold_in` is the input that indicates when the inside temperature is
  too cold.

- `hot_out` is the input that indicates when the outside temperature is
  hot.

- `cold_out` is the input that indicates when the outside temperature is
  cold.

## Output

- `open_window` is the output that controls the opening of the window.

- `heater` is the output that activates the heater.

- `cooler` is the output that activates the cooler.

## Problem information

Author: Jordi Cortadella

Generation: 2026-02-03T12:15:23.822Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
