# $n$-bit adder/subtractor

Design a circuit that performs the addition or subtraction of two
$n$-bit numbers. The result (mod $2^n$) must be represented in $n$ bits
also. The circuit has an input (`op`) that indicates which operation
must be performed (0 for addition, 1 for subtraction).

The number of bits must be a parameter of the module, with a default
value as shown in the specification.

## Specification

``` verilog
module add_sub (a, b, op, result);
    parameter N=16;
    input [N-1:0] a, b;
    input op;
    output [N-1:0] result;
```

## Input

- `a` and `b` are the two $n$-bit operands.

- `op` indicates the type of operation (0 for addition, 1 for
  subtraction).

## Output

- `result` is the $n$-bit result of the operation (mod $2^n$).

## Problem information

Author: Jordi Cortadella

Generation: 2026-02-03T12:12:01.702Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
