# Més combinacions en Esperanto (III)

L'Esperanto és una llengua *artificial*, és a dir, creada de manera
expressa per humans, en contrast amb les altres llengües que s'anomenen
*naturals*, com per exemple, el català. Va ser creada pel oftalmòleg
jueu polonès **Ludwik Lejzer Zamenhof**. La seva intenció era crear una
llengua que no fos de ningú i que, alhora, pogués ser de tothom qui ho
volgués facilitant així l'entesa entre parlants de llengües diferents.
Pretenia que no fos un dels dos parlants qui hagués de cedir cap a
l'altra llengua, sinó que tots dos haguessin de cedir i fer servir
aquesta llengua *auxiliar*.

L'Esperanto té 16 regles gramaticals, i en aquesta pràctica en farem
servir tres:

1.  Els *pronoms personals* (independentment del gènere) acaben en la
    lletra **-i**. Per exemple, **mi** (jo), o **li** (ell).

2.  Els *verbs* en present d'indicatiu (independentment del subjecte)
    acaben en **-as**. Per exemple, **legas**
    (llegeixo/llegeixes/llegeix/llegim/llegiu/llegeixen), o **pensas**
    (penso/penses/pensa/pensem/penseu/pensen).

3.  Els *complements directes* acaben en la lletra **-n**. Això es fa
    afegint la lletra **-n** a qualsevol paraula. Per exemple, **libro**
    (llibre) $\rightarrow$ **libron**, o **tempo** (temps) $\rightarrow$
    **tempon**.

La pràctica consisteix en **tres exercicis** que cal fer de manera
**acumulativa**. Això vol dir que per a fer aquesta tercera part caldrà
fer servir el que hagueu fet (si funciona bé) a la primera part.

# Tercera Part

La **tercera part** consisteix a fer una funció que, donades tres
llistes `PRONOMS`, `VERBS` i `OBJECTES`, formi totes les possibles
combinacions de *pronom* *verb* i *objecte* (separats per un espai).

Concretament, la funció serà aquesta:

`calculaTriples(PRONOMS,VERBS,OBJECTES)`

- `PRONOMS` és una llista que conté paraules que acaben en la lletra
  **i**. `VERBS` és una llista que té paraules que acaben en **s**.
  `OBJECTES` és una llista que té paraules que acaben en **n**.

- Torna una llista amb totes les combinacions que es pot fer
  `pronom verb objecte`, separades per un espai.

Com es pot observar, l'ordre de les combinacions ha de respectar l'ordre
que hi ha en les llistes `PRONOMS`, `VERBS` i `OBJECTES`.

Recordeu que podeu concatenar `strings` fent servir l'operador de suma.
Per exemple, `"mi" + " "  + "legas" + " " + "libron"` avalua a
`"mi legas libron"`.

## Observació

Només has d'enviar el fitxer amb la funció (i les funcions auxiliars que
hagis fet) que et demanem i prou. El fitxer `main.py` et pot servir per
provar la teva solució, però en cap cas has d'enviar el seu contingut.

## Entrada

paraula1

paraula2 \...

acabada en la paraula FINO

## Sortida

Tres llistes que contenen els pronoms (acabats en *i*) els verbs
(acabats en *s*) i els objectes (acabats en *n*) que llegim del canal
d'entrada.

Donades les tres llistes anteriors, genera tots els triplets *pronom
verb objecte*.

## Informació del problema

Autoria: INFO EPSEVG

Generació: 2026-01-25T19:54:18.455Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
