# Traffic-light controller

Design a controller for the traffic lights in the crossing of two
unidirectional streets. One street goes from North to South (NS) and the
other street goes from West to East (WE). Each street has a sensor that
detects the presence of cars approaching to the traffic light.

For simplicity, we will assume that the traffic lights can only have two
colors, red and green, and they switch simultaneously. This means that
there is always one light at red and one light at green.

The controller must be designed in a way that cars do not have to wait
more than necessary. If there are cars willing to cross in only one
direction, the lights will give priority to them. If there are cars
willing to cross in both directions, the traffic lights will not change.
However, there is one exception: the system also has a timer that
indicates that the traffic lights have not switched for a long time
(possibly because there was heavy traffic going to one direction). In
that case, if there are cars in both directions, the lights will switch.

In case there are no cars in either direction, the lights will not
change regardless the indication of the timer.

After resetting the controller, the lights must give priority to the
North-South direction.

::: center
![image](traffic_light.svg){width="6cm"}
:::

## Specification

``` verilog
module traffic_light(NScar, WEcar, Timer, NSWE_light, clk, rst);
    input NScar, WEcar, Timer, clk, rst;
    output NSWE_light;
```

## Input

- `NScar` is 1 when the sensor detects the presence of cars in the
  North-South direction.

- `WEcar` is 1 when the sensor detects the presence of cars in the
  West-East direction.

- `Timer` is 1 when the lights have not changed for a long time.

- `clk` is the clock of the controller.

- `rst` is the synchronous reset signal.

## Output

- `NSWE_light` is the output signal. When 0, it allows cars to cross in
  the North-South direction. When 1, it allows cars to cross in the
  West-East direction.

## Problem information

Author: Jordi Cortadella

Generation: 2026-02-03T12:24:03.863Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
