# Més combinacions en Esperanto (I)

L'Esperanto és una llengua *artificial* és a dir, creada de manera
expressa per humans, en contrast amb les altres llengües que s'anomenen
*naturals*, com per exemple, el català. Va ser creada pel oftalmòleg
jueu polonès **Ludwik Lejzer Zamenhof**. La seva intenció era crear una
llengua que no fos de ningú i que, alhora, pogués ser de tothom qui ho
volgués, facilitant així l'entesa entre parlants de llengües diferents,
de manera que no fos un dels dos parlants qui hagués de cedir cap a
l'altra llengua, sinó que tots dos haguessin de cedir i fer servir
aquesta llengua *auxiliar*.

L'Esperanto té 16 regles gramaticals, i en aquesta pràctica en farem
servir tres:

1.  Els *pronoms personals* (independentment del gènere) acaben en la
    lletra **-i**. Per exemple, **mi** (jo), o **li** (ell).

2.  Els *verbs* en present d'indicatiu (independentment del subjecte)
    acaben en **-as**. Per exemple, **legas**
    (llegeixo/llegeixes/llegeix/llegim/llegiu/llegeixen), o **pensas**
    (penso/penses/pensa/pensem/penseu/pensen).

3.  Els *complements directes* acaben en la lletra **-n**. Això es fa
    afegint la lletra **-n** a qualsevol paraula. Per exemple, **libro**
    (llibre) $\rightarrow$ **libron**, o **tempo** (temps) $\rightarrow$
    **tempon**.

La pràctica consisteix en **tres exercicis** que cal fer de manera
**acumulativa**. Això vol dir que per a fer la segona i a la tercera
part caldrà fer servir el que hagueu fet (si funciona bé) a la primera
part.

# Primera Part

La **primera part** de la pràctica consistirà en, donat una seqüència
d'entrada amb aquest format:

`paraula_1`

`paraula_2`

`paraula_3`

`...`

`paraula_n`

`FINO`

on cada paraula `paraula_i` acabarà en la lletra **i**, en la lletra
**s** o en la lletra **n**, fer la funció:

`entraSeq ()`

- El canal d'entrada conté **únicament** paraules que acaben en `i`, en
  `s` o en `n`. No estan necessàriament en ordre alfabètic, i no hi ha
  cap paraula repetida. A més, n'hi ha almenys una per cada terminació.

- Torna tres llistes: `PRONOMS`, `VERBS` i `OBJECTES` tals que `PRONOMS`
  conté totes les paraules que apareixen al canal d'entrada i que acaben
  en la lletra **i** en el mateix ordre en què apareixen al canal
  d'entrada. La llista `VERBS` contindrà totes les que acaben en **s**.
  La llista `OBJECTES` contindrà totes les que acaben en **n**.

Com podeu veure, aquesta funció no rep cap paràmetre, i simplement torna
tres llistes.

## Observació

Només has d'enviar el fitxer amb la funció (i les funcions auxiliars que
hagis fet) que et demanem i prou. El fitxer `main.py` et pot servir per
provar la teva solució, però en cap cas has d'enviar el seu contingut.

## Entrada

paraula1 paraula2 \...

acabada en la paraula FINO

## Sortida

Tres llistes que contenen els pronoms (acabats en *i*) del canal
d'entrada, els verbs (acabats en *s*) i els objectes (acabats en *n*).

## Informació del problema

Autoria: INFO EPSEVG

Generació: 2026-01-25T19:53:25.674Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
