# Números redondos (2)

En este ejercicio, diremos que un natural $n$ es redondo en base $b$, si
la suma de sus dígitos en base $b$ coincide con el número de dígitos en
esta base.

Por ejemple, el número 34 no es redondo en base $10$ ($3 + 4 \neq 2$),
pero sí que lo es en base $3$, porque
$$1\cdot 3^3 + 0\cdot  3^2 + 2 \cdot 3^1 + 1 \cdot 3^0 = 34 \text{  y }  1 + 0 + 2 + 1 = 4.$$
Como otro ejemplo, $511$ no es redondo en base $16$ ya que
$$1 \cdot  16^2 + 15 \cdot  16^1 + 15 \cdot  16^0 = 511  \text{ y } 1 + 15 + 15 = 31 \neq 3,$$
pero sí que lo es en base $2$ (tiene $9$ unos, que suman $9$). Todavía
otro ejemplo más: $370273$ no es redondo en base $2$, ni en base $3$,
..., pero sí que lo es en base $608$, porque
$$1 \cdot  608^2 + 1 \cdot  608^1 + 1 \cdot 608^0 = 370273 \text{ y } 1 + 1 + 1 = 3.$$

Una secuencia de pares de naturales $(n,b)$, dónde $n$ es un natural y
$b\geq 2$, es *bi-redonda* si contiene al menos dos pares $(n,b)$ con la
propiedad que $n$ es redondo en base $b$.

Escribid un programa que, dada una secuencia de pares de naturales,
indique si es o no bi-redonda.

Vuestro programa tiene que incluir, usar e implementar, la función

        bool redondo (int n, int b);

que indica si un natural $n$ es redondo en base $b$ o no.

## Entrada

La entrada es una secuencia no vacía de pares de naturales $(x,b)$ con
$b\geq 2$.

## Salida

Hay que escribir si la secuencia de entrada es o no bi-redonda.

Seguid el formato especificado en los ejemplos. Vuestro código debe
seguir las normas de estilo y contener los comentarios que consideréis
oportunos.

## Información del problema

Autoría: Unknown\
Traducción: Maria Serna

Generación: 2026-01-25T16:58:34.375Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
