# Round numbers (2)

In this exercise, we say that a natural number is *round* in base $b$,
when the sum of of its digits in base $b$ equals its number of digits in
this base.

For example, the number 34 is not round in base $10$ ($3 + 4 \neq 2$),
but it is round in base $3$, as
$$1\cdot 3^3 + 0\cdot  3^2 + 2 \cdot 3^1 + 1 \cdot 3^0 = 34 \text{  and }  1 + 0 + 2 + 1 = 4.$$
As another example, $511$ is not round in base $16$ as
$$1 \cdot  16^2 + 15 \cdot  16^1 + 15 \cdot  16^0 = 511  \text{ and } 1 + 15 + 15 = 31 \neq 3,$$
but it is round in base $2$ (it has $9$ ones, that add up to $9$).
Another example: $370273$ is not round in base $2$, neither in base $3$,
..., however it is round in base $608$, because
$$1 \cdot  608^2 + 1 \cdot  608^1 + 1 \cdot 608^0 = 370273 \text{ and } 1 + 1 + 1 = 3.$$

A sequence of pairs of natural numbers $(n,b)$, where $n$ is a natural
number and $b\geq 2$, is called *bi-round* if it does contain at least
two pairs $(n,b)$ with the property that $n$ is round in base $b$.

Write a program that, given a sequence of pairs of natural numbers,
determines whether it is bi-round or not.

Your program must include, use and implement the function

        bool round (int n, int b);

that indicates if a natural number is round on base $b$ or not.

## Input

The input is a non-empty sequence of pairs of natural numbers $(x,b)$
with $b\geq 2$.

## Output

The program has to write if the input sequence is bi-round or not.

Please follow the format described in the examples. Your code should
follow the style rules and include the appropriate comments.

## Problem information

Author: Unknown\
Translator: Maria Serna

Generation: 2026-01-25T16:58:38.490Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
