# Nombres rodons (2)

En aquest exercici, direm que un natural $n$ és rodó en base $b$, si la
suma dels seus dígits en base $b$ coincideix amb el nombre de dígits en
aquesta base.

Per exemple, el nombre 34 no és rodó en base $10$ ($3 + 4 \neq 2$), però
sí que ho és en base $3$, perquè
$$1\cdot 3^3 + 0\cdot  3^2 + 2 \cdot 3^1 + 1 \cdot 3^0 = 34 \text{  i }  1 + 0 + 2 + 1 = 4.$$
Com un altre exemple, $511$ no és rodó en base $16$ ja què
$$1 \cdot  16^2 + 15 \cdot  16^1 + 15 \cdot  16^0 = 511  \text{ i } 1 + 15 + 15 = 31 \neq 3,$$
però sí que ho és en base $2$ (té $9$ uns, que sumen $9$). Encara un
exemple més: $370273$ no és rodó en base $2$, ni en base $3$, ..., però
sí que ho és en base $608$, perquè
$$1 \cdot  608^2 + 1 \cdot  608^1 + 1 \cdot 608^0 = 370273 \text{ i }1 + 1 + 1 = 3.$$

Una sequència de parells de naturals $(n,b)$, on $n$ és un natural i
$b\geq 2$, es *bi-rodona* si conté al menys dos parells $(n,b)$ amb la
propietat que $n$ és rodó en base $b$.

Feu un programa que, donada una seqüència de parells de naturals,
indiqui si és o no bi-rodona.

El vostre programa ha d'incloure, usar i implementar, la funció

        bool rodo (int n, int b);

que indica si un natural $n$ és rodó en base $b$ o no.

## Entrada

L'entrada és una seqüència no buida de parells de naturals $(x,b)$ amb
$b\geq 2$.

## Sortida

Cal escriure si la seqüència d'entrada és o no bi-rodona.

Seguiu el format especificat als exemples. El vostre codi ha de seguir
les normes d'estil i contenir els comentaris que considereu oportuns.

## Informació del problema

Autoria: Professorat de PRO1

Generació: 2026-01-25T16:58:42.272Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
