# Práctica de PRO2 - Otoño 2023 - entrega provisional

Este problema es el único canal disponible para realizar **la entrega
provisional** de la práctica. Tened en cuenta que

- Más adelante habrá otro problema del jutge para hacer la entrega
  definitiva que incluye documentación extra.

- El plazo de entrega definitiva acaba el domingo 17 de diciembre, a las
  22h.

- No superar ningún juego de pruebas conllevará un cero en la nota de la
  práctica

- Pueden realizarse tantas entregas como se quiera, pero solo se tendrá
  en cuenta la más reciente que no sea SE (\"Setter Error").

- En esta entrega solo hay que enviar el código de la práctica y el
  Makefile.

- Este problema de la entrega provisional seguirá disponible hasta horas
  antes del fin del plazo de entrega. De hecho, recomendamos usarlo para
  probar el código mientras no tengáis preparado el material adicional
  que pedimos y esté disponible la entrega final definitiva.

## Observación

El Jutge prueba vuestras entregas mediante 4 juegos de pruebas:

- sample: el juego de pruebas público

- privat1: un poco de todo, especialmente *subir bicis*, salvo
  eficiencia

- privat2: un poco de todo, especialmente *asignar estacion*, salvo
  eficiencia

- privat3: eficiencia

En un fichero llamado `practica.tar` tenéis que entregar

- Los ficheros .hh y .cc de las clases y el programa principal. No
  incluyáis ficheros .o, .exe y similares

- El fichero **Makefile**, que usaremos para generar y probar el
  ejecutable; un Makefile incorrecto puede dar lugar a malos resultados
  en el Jutge o a penalización en la nota manual

Tened en cuenta las siguientes restricciones:

- El fichero que contiene el programa principal se ha de llamar
  `program.cc`

- El Makefile ha de generar un ejecutable llamado `program.exe`

- Es importante que uséis las opciones de compilación del Jutge de PRO2
  (ved Documentation $\rightarrow$ Compilers $\rightarrow$ PRO2 a
  www.jutge.org)

- No usar la opción `-D_GLIBCXX_DEBUG` o usarla de forma incorrecta
  podrá ser penalizado

- No usar la opción `-fno-extended-identifiers` **comporta un 0 en la
  práctica**.

Producid el fichero `practica.tar` con la instrucción Linux

    tar -cvf practica.tar fitxer1 fitxer2 fitxer3 ...

desde el directorio/carpeta donde tengáis los ficheros que vais a
entregar. Incluid esta instrucción en vuestro Makefile, de forma que el
`.tar` se pueda generar ejecutando `make practica.tar`. Con eso
reduciréis el riesgo de error en sucesivas entregas. El Jutge no acepta
`.tar` donde los ficheros estén dentro de carpetas. Recomendamos usar
`GNU tar` para reducir el riesgo de que el fichero `practica.tar` sea
incompatible con el Jutge. No es necesario incluir `BinTree.hh` en
`practica.tar`.

## Información del problema

Autoría: PRO2

Generación: 2026-01-25T21:31:44.858Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
